<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @since             1.0.0
 * @package           Axonaut
 *
 * @wordpress-plugin
 * Plugin Name:       Axonaut
 * Plugin URI:        https://axonaut.com
 * Description:       Synchronisez votre boutique WooCommerce avec Axonaut, votre CRM/ERP tout-en-un en ligne ! Clients, produits, commandes : toutes vos données générées automatiquement.
 * Version:           2.3.13
 * Author:            Axonaut
 * Author URI:        https://axonaut.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       axonaut
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

/**
 * Currently pligin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('PLUGIN_NAME_VERSION', '1.1.0');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-axonaut-activator.php
 */
function activate_axonaut()
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-axonaut-activator.php';
    Axonaut_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-axonaut-deactivator.php
 */
function deactivate_axonaut()
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-axonaut-deactivator.php';
    Axonaut_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_axonaut');
register_deactivation_hook(__FILE__, 'deactivate_axonaut');


function ap_action_init()
{
    // Localization
    load_plugin_textdomain( 'axonaut', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action('init', 'ap_action_init');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-axonaut.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */

function run_axonaut()
{
    $plugin = new Axonaut();
    $plugin->run();
}

run_axonaut();