/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "react/jsx-runtime":
/*!**********************************!*\
  !*** external "ReactJSXRuntime" ***!
  \**********************************/
/***/ ((module) => {

module.exports = window["ReactJSXRuntime"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!**********************************!*\
  !*** ./assets/blocks/blocks.jsx ***!
  \**********************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

/* global wc, wp */
(() => {
  // Bail if Blocks globals aren’t present
  if (!window.wp || !window.wc) return;
  const {
    __,
    sprintf
  } = wp.i18n || {
    __: s => s,
    sprintf: s => s
  };
  const {
    registerPlugin
  } = wp.plugins;
  const {
    Notice
  } = wp.components;
  const {
    useState
  } = wp.element;
  const {
    useDispatch,
    useSelect
  } = wp.data;

  // Woo Blocks slot and helpers
  const blocksCheckout = wc.blocksCheckout || wc.blocks || {};
  const {
    ExperimentalOrderMeta,
    extensionCartUpdate
  } = blocksCheckout || {};

  // Cart data store key
  const cartStore = wc.wcBlocksData && wc.wcBlocksData.cartStore || 'wc/store/cart';
  if (!ExperimentalOrderMeta || !useDispatch || !useSelect) return;

  // Store API extensions namespace
  const NAMESPACE = 'pw-gift-cards';
  const ApplyGiftCard = () => {
    const [code, setCode] = useState('');
    const [isSubmitting, setIsSubmitting] = useState(false);
    const [notice, setNotice] = useState(null);

    // Get full cart data so we can read our extension data
    const cartData = useSelect(select => {
      const s = select(cartStore);
      return s && s.getCartData ? s.getCartData() : null;
    }, []);

    // Applied gift cards coming from the Store API extensions payload
    const giftCards = cartData && cartData.extensions && cartData.extensions[NAMESPACE] && cartData.extensions[NAMESPACE].gift_cards || [];
    const submit = async () => {
      if (!code) {
        setNotice({
          status: 'error',
          message: __('Enter a gift card code.', 'pw-woocommerce-gift-cards')
        });
        return;
      }
      setIsSubmitting(true);
      setNotice(null);
      try {
        await extensionCartUpdate({
          namespace: NAMESPACE,
          data: {
            code
          }
        });
        setCode('');
      } catch (err) {
        setNotice({
          status: 'error',
          message: err?.message || __('Something went wrong.', 'pw-woocommerce-gift-cards')
        });
      } finally {
        setIsSubmitting(false);
      }
    };
    const handleRemove = async cardNumber => {
      setIsSubmitting(true);
      setNotice(null);
      try {
        await extensionCartUpdate({
          namespace: NAMESPACE,
          data: {
            code: cardNumber,
            remove: true
          }
        });
      } catch (err) {
        setNotice({
          status: 'error',
          message: err?.message || __('Unable to remove gift card.', 'pw-woocommerce-gift-cards')
        });
      } finally {
        setIsSubmitting(false);
      }
    };
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ExperimentalOrderMeta, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        id: "pwgc-redeem-gift-card-container",
        children: [giftCards.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
          className: "pwgc-applied-gift-cards",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
            className: "pwgc-applied-gift-cards-title",
            children: __('Gift cards applied', 'pw-woocommerce-gift-cards')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", {
            className: "pwgc-applied-gift-cards-list",
            children: giftCards.map(card => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("li", {
              className: "pwgc-applied-gift-cards-item",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: "pwgc-applied-gift-cards-left",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
                  className: "pwgc-gift-card-number",
                  children: card.number
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
                  className: "pwgc-gift-card-remaining-balance",
                  children: card.balance && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
                    className: "pwgc-gift-card-balance",
                    children: sprintf(__('Remaining balance is %s', 'pw-woocommerce-gift-cards'), card.balance)
                  })
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
                className: "pwgc-applied-gift-cards-right",
                children: card.amount && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
                  className: "pwgc-gift-card-amount",
                  children: [card.amount, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("button", {
                    type: "button",
                    className: "pwgc-remove-gift-card",
                    onClick: () => handleRemove(card.number),
                    "aria-label": sprintf(__('Remove gift card %s', 'pw-woocommerce-gift-cards'), card.number),
                    disabled: isSubmitting,
                    children: "\xD7"
                  })]
                })
              })]
            }, card.number))
          })]
        }), !window.pwgcBlocks.hideRedeemForm && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("form", {
          id: "pwgc-redeem-gift-card-form",
          onSubmit: e => {
            e.preventDefault();
            submit();
          },
          noValidate: true,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", {
            htmlFor: "pwgc-redeem-gift-card-number",
            children: __('Have a gift card?', 'pw-woocommerce-gift-cards')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", {
            id: "pwgc-redeem-gift-card-number",
            type: "text",
            value: code,
            onChange: e => setCode(e.target.value),
            placeholder: __('Gift card number', 'pw-woocommerce-gift-cards'),
            "aria-label": __('Gift card number', 'pw-woocommerce-gift-cards'),
            disabled: isSubmitting
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("button", {
            type: "submit",
            className: `pwgc-apply-gift-card-button wc-block-components-button ${isSubmitting ? 'is-loading' : ''}`,
            disabled: isSubmitting,
            "aria-busy": isSubmitting,
            children: __('Apply Gift Card', 'pw-woocommerce-gift-cards')
          }), notice && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Notice, {
            status: notice.status,
            isDismissible: false,
            children: notice.message
          })]
        })]
      })
    });
  };

  // Register for both checkout and cart scopes
  registerPlugin('pw-apply-gift-card-checkout', {
    render: ApplyGiftCard,
    scope: 'woocommerce-checkout'
  });
  registerPlugin('pw-apply-gift-card-cart', {
    render: ApplyGiftCard,
    scope: 'woocommerce-cart'
  });
})();
})();

/******/ })()
;
//# sourceMappingURL=blocks.js.map