<?php
/**
 * Email Downloads.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/email-downloads.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 10.4.0
 */

use Automattic\WooCommerce\Utilities\FeaturesUtil;

defined( 'ABSPATH' ) || exit;

$email_improvements_enabled = FeaturesUtil::feature_is_enabled( 'email_improvements' );

?><h2 class="woocommerce-order-downloads__title<?php echo $email_improvements_enabled ? ' email-order-detail-heading' : ''; ?>"><?php esc_html_e( 'Downloads', 'woocommerce' ); ?></h2>

<table
	class="td font-family<?php echo $email_improvements_enabled ? ' email-order-details' : ''; ?>"
	cellspacing="0"
	cellpadding="<?php echo $email_improvements_enabled ? '0' : '6'; ?>"
	style="width: 100%; margin-bottom: 40px;"
	border="<?php echo $email_improvements_enabled ? '0' : '1'; ?>"
>
	<thead>
		<tr>
			<?php foreach ( $columns as $column_id => $column_name ) : ?>
				<th class="td <?php echo $email_improvements_enabled && array_key_last( $columns ) === $column_id ? 'text-align-right' : 'text-align-left'; ?>" scope="col">
					<?php echo esc_html( $column_name ); ?>
				</th>
			<?php endforeach; ?>
		</tr>
	</thead>

	<?php foreach ( $downloads as $download ) : ?>
		<tr>
			<?php foreach ( $columns as $column_id => $column_name ) : ?>
				<?php
				$column_alignment_class = $email_improvements_enabled && array_key_last( $columns ) === $column_id ? 'text-align-right' : 'text-align-left';
				if ( 'download-product' === $column_id ) :
					?>
					<th class="td <?php echo esc_attr( $column_alignment_class ); ?>" scope="row">
				<?php else : ?>
					<td class="td <?php echo esc_attr( $column_alignment_class ); ?>">
				<?php endif; ?>
					<?php
					if ( has_action( 'woocommerce_email_downloads_column_' . $column_id ) ) {
						do_action( 'woocommerce_email_downloads_column_' . $column_id, $download, $plain_text );
					} else {
						switch ( $column_id ) {
							case 'download-product':
								?>
								<a href="<?php echo esc_url( get_permalink( $download['product_id'] ) ); ?>"><?php echo wp_kses_post( $download['product_name'] ); ?></a>
								<?php
								break;
							case 'download-file':
								?>
								<a href="<?php echo esc_url( $download['download_url'] ); ?>" class="woocommerce-MyAccount-downloads-file button alt"><?php echo esc_html( $download['download_name'] ); ?></a>
								<?php
								break;
							case 'download-expires':
								if ( ! empty( $download['access_expires'] ) ) {
									?>
									<time datetime="<?php echo esc_attr( date( 'Y-m-d', strtotime( $download['access_expires'] ) ) ); ?>" title="<?php echo esc_attr( strtotime( $download['access_expires'] ) ); ?>"><?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $download['access_expires'] ) ) ); ?></time>
									<?php
								} else {
									esc_html_e( 'Never', 'woocommerce' );
								}
								break;
						}
					}
					?>
					<?php if ( 'download-product' === $column_id ) : ?>
						</th>
					<?php else : ?>
						</td>
					<?php endif; ?>
			<?php endforeach; ?>
		</tr>
	<?php endforeach; ?>
</table>
