<?php
if ( ! defined( 'ABSPATH' ) ) exit;

\spl_autoload_register( function ( $class ) {
    static $map = array(
        'RelaisColisWoocommerce\\Relais_Colis_Woocommerce_Loader' => 'relais-colis-woocommerce.php',
        'RelaisColisWoocommerce\\Relais_Colis_Woocommerce' => 'class-relais-colis-woocommerce.php',
        // 'RelaisColisWoocommerce\\Tests\\Relais_Colis_Woocommerce_Tests' => 'tests/class-relais-colis-woocommerce-tests.php',
        // WP FW
        'RelaisColisWoocommerce\\WPFw\\Api\\WP_API_Base' => 'includes/wpfw/api/class-wp-api-base.php',
        'RelaisColisWoocommerce\\WPFw\\Api\\WP_API_Request' => 'includes/wpfw/api/interface-wp-api-request.php',
        'RelaisColisWoocommerce\\WPFw\\Api\\WP_API_Response' => 'includes/wpfw/api/abstract-wp-api-response.php',
        'RelaisColisWoocommerce\\WPFw\\Api\\WP_API_JSON_Request' => 'includes/wpfw/api/abstract-wp-api-json-request.php',
        'RelaisColisWoocommerce\\WPFw\\Api\\WP_API_JSON_Response' => 'includes/wpfw/api/abstract-wp-api-json-response.php',
        'RelaisColisWoocommerce\\WPFw\\Api\\WP_API_XML_Request' => 'includes/wpfw/api/abstract-wp-api-xml-request.php',
        'RelaisColisWoocommerce\\WPFw\\Api\\WP_API_XML_Response' => 'includes/wpfw/api/abstract-wp-api-xml-response.php',
        'RelaisColisWoocommerce\\WPFw\\Traits\\Singleton' => 'includes/wpfw/traits/trait-singleton.php',
        'RelaisColisWoocommerce\\WPFw\\Traits\\Plugin_Action_Links' => 'includes/wpfw/traits/trait-plugin-action-links.php',
        'RelaisColisWoocommerce\\WPFw\\Traits\\Plugin_Activation_Control' => 'includes/wpfw/traits/trait-plugin-activation-control.php',
        'RelaisColisWoocommerce\\WPFw\\Utils\\WP_Log' => 'includes/wpfw/utils/class-wp-logger.php',
        'RelaisColisWoocommerce\\WPFw\\Utils\\WP_Helper' => 'includes/wpfw/utils/class-wp-helper.php',
        'RelaisColisWoocommerce\\WPFw\\Utils\\WP_Admin_Notices_Manager' => 'includes/wpfw/utils/class-wp-admin-notices-manager.php',
        'RelaisColisWoocommerce\\WPFw\\WP_PLoad' => 'includes/wpfw/abstract-wp-plugin-loader.php',
        'RelaisColisWoocommerce\\WPFw\\WP_Plugin' => 'includes/wpfw/abstract-wp-plugin.php',
        // RC API
        'RelaisColisWoocommerce\\RCAPI\\WP_Relais_Colis_API' => 'includes/rcapi/class-wp-relais-colis-api.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relais_Colis_API_Exception' => 'includes/rcapi/class-wp-relais-colis-api-exception.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relais_Colis_Response_Factory' => 'includes/rcapi/class-wp-relais-colis-response-factory.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relais_Colis_Request_Factory' => 'includes/rcapi/class-wp-relais-colis-request-factory.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Enseigne' => 'includes/rcapi/trait-wp-relacoof-enseigne.php',
        // RC API RESPONSES
        'RelaisColisWoocommerce\\RCAPI\\WP_Relais_Colis_Error_Response' => 'includes/rcapi/responses/class-wp-relais-colis-error-response.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relais_Colis_Response' => 'includes/rcapi/responses/abstract-wp-relais-colis-response.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Get_Configuration_Response' => 'includes/rcapi/responses/class-wp-relacoof-get-configuration-response.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Place_Advertisement_Response' => 'includes/rcapi/responses/class-wp-relacoof-place-advertisement-response.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_B2C_Place_Return_Response' => 'includes/rcapi/responses/class-wp-relacoof-btoc-place-return-response.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Etiquette_Generate_Response' => 'includes/rcapi/responses/class-wp-relacoof-etiquette-generate-response.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Transport_Generate_Response' => 'includes/rcapi/responses/class-wp-relacoof-transport-generate-response.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Get_Infos_Response' => 'includes/rcapi/responses/class-wp-relacoof-get-infos-response.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_C2C_Get_Packages_Price_Response' => 'includes/rcapi/responses/class-wp-relacoof-ctoc-get-packages-price-response.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Get_Packages_Status_Response' => 'includes/rcapi/responses/class-wp-relacoof-get-packages-status-response.php',
        // RC API REQUESTS
        'RelaisColisWoocommerce\\RCAPI\\WP_Relais_Colis_Request' => 'includes/rcapi/requests/abstract-wp-relais-colis-request.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_B2C_Get_Configuration' => 'includes/rcapi/requests/class-wp-relacoof-btoc-get-configuration.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_C2C_Get_Configuration' => 'includes/rcapi/requests/class-wp-relacoof-ctoc-get-configuration.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Bulk_Generate' => 'includes/rcapi/requests/class-wp-relacoof-bulk-generate.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Generate' => 'includes/rcapi/requests/abstract-wp-relacoof-generate.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_B2C_Generate' => 'includes/rcapi/requests/class-wp-relacoof-btoc-generate.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_C2C_Generate' => 'includes/rcapi/requests/class-wp-relacoof-ctoc-generate.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Place_Advertisement_Request' => 'includes/rcapi/requests/abstract-wp-relacoof-place-advertisement-request.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_B2C_Relay_Place_Advertisement' => 'includes/rcapi/requests/class-wp-relacoof-btoc-relay-place-advertisement.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_B2C_Home_Place_Advertisement' => 'includes/rcapi/requests/class-wp-relacoof-btoc-home-place-advertisement.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_C2C_Relay_Place_Advertisement' => 'includes/rcapi/requests/class-wp-relacoof-ctoc-relay-place-advertisement.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Place_Return' => 'includes/rcapi/requests/abstract-wp-relacoof-place-return.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Place_Return_V2' => 'includes/rcapi/requests/class-wp-relacoof-place-return-v2.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Place_Return_V3' => 'includes/rcapi/requests/class-wp-relacoof-place-return-v3.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_C2C_Get_Infos' => 'includes/rcapi/requests/class-wp-relacoof-ctoc-get-infos.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_C2C_Get_Packages_Price' => 'includes/rcapi/requests/class-wp-relacoof-ctoc-get-packages-price.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Transport_Generate' => 'includes/rcapi/requests/class-wp-relacoof-transport-generate.php',
        'RelaisColisWoocommerce\\RCAPI\\WP_Relacoof_Get_Packages_Status' => 'includes/rcapi/requests/class-wp-relacoof-get-packages-status.php',
        // WOOCOMMERCE
        'RelaisColisWoocommerce\\WC_Relacoof_WooCommerce_Manager' => 'includes/woocommerce/class-wc-relacoof-woocommerce-manager.php',
        'RelaisColisWoocommerce\\WC_Relacoof_Services_Manager' => 'includes/woocommerce/class-wc-relacoof-services-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Config_Manager' => 'includes/woocommerce/class-wc-relacoof-shipping-config-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Constants' => 'includes/woocommerce/abstract-wc-relacoof-shipping-constants.php',
        // CHECKOUT
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Checkout_Scripts_Manager' => 'includes/woocommerce/checkout/class-wc-relacoof-checkout-scripts-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Choose_Services_Manager' => 'includes/woocommerce/checkout/abstract-wc-relacoof-choose-services-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Home_Choose_Services_Manager' => 'includes/woocommerce/checkout/class-wc-relacoof-home-choose-services-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Homeplus_Choose_Services_Manager' => 'includes/woocommerce/checkout/class-wc-relacoof-homeplus-choose-services-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Relay_Choose_Relay_Manager' => 'includes/woocommerce/checkout/class-wc-relacoof-relay-choose-relay-manager.php',
        // METHODS
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Method_Manager' => 'includes/woocommerce/methods/class-wc-relacoof-shipping-method-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Method' => 'includes/woocommerce/methods/abstract-wc-relacoof-shipping-method.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Method_Relay' => 'includes/woocommerce/methods/class-wc-relacoof-shipping-method-relay.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Method_Home' => 'includes/woocommerce/methods/class-wc-relacoof-shipping-method-home.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Method_Homeplus' => 'includes/woocommerce/methods/class-wc-relacoof-shipping-method-homeplus.php',
        // SETTINGS
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Settings_Manager' => 'includes/woocommerce/settings/class-wc-relacoof-shipping-settings-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Settings' => 'includes/woocommerce/settings/class-wc-relacoof-shipping-settings.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_General_Settings' => 'includes/woocommerce/settings/class-wc-relacoof-shipping-general-settings.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Units_Settings' => 'includes/woocommerce/settings/class-wc-relacoof-shipping-units-settings.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Infos_Settings' => 'includes/woocommerce/settings/class-wc-relacoof-shipping-Infos-settings.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Services_Settings' => 'includes/woocommerce/settings/class-wc-relacoof-shipping-services-settings.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Tariff_Grids_Settings' => 'includes/woocommerce/settings/class-wc-relacoof-shipping-tariff-grids-settings.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Ajax_Get_Wc_Products' => 'includes/woocommerce/settings/ajax/class-wc-relacoof-ajax-get-wc-products.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Ajax_Refresh_Infos' => 'includes/woocommerce/settings/ajax/class-wc-relacoof-ajax-refresh-infos.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Field_Tariff_Grids' => 'includes/woocommerce/settings/fields/class-wc-relacoof-shipping-field-tariff-grids.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Field_Copy_Paste_Button' => 'includes/woocommerce/settings/fields/class-wc-relacoof-shipping-field-copy-paste-button.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Field_Refresh_Button' => 'includes/woocommerce/settings/fields/class-wc-relacoof-shipping-field-refresh-button.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Field_Enable' => 'includes/woocommerce/settings/fields/class-wc-relacoof-shipping-field-enable.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Field_Custom_Html' => 'includes/woocommerce/settings/fields/class-wc-relacoof-shipping-field-custom-html.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Shipping_Field_Multiselect_Products' => 'includes/woocommerce/settings/fields/class-wc-relacoof-shipping-field-multiselect-products.php',
        // ORDERS
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Orders_Manager' => 'includes/woocommerce/orders/class-wc-relacoof-orders-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Customer_Orders_Manager' => 'includes/woocommerce/orders/class-wc-relacoof-customer-orders-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Emails_Orders_Manager' => 'includes/woocommerce/orders/class-wc-relacoof-emails-orders-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Order_Shipping_Infos_Manager' => 'includes/woocommerce/orders/class-wc-relacoof-order-shipping-infos-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Orders_RC_Status_Manager' => 'includes/woocommerce/orders/class-wc-relacoof-orders-rc-status-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Orders_List_Table_Manager' => 'includes/woocommerce/orders/class-wc-relacoof-orders-list-table-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Orders_C2c_Csv_Export_Manager' => 'includes/woocommerce/orders/class-wc-relacoof-orders-c2c-csv-export-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Order_Packages_Manager' => 'includes/woocommerce/orders/class-wc-relacoof-order-packages-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Ajax_Packages' => 'includes/woocommerce/orders/ajax/class-wc-relacoof-ajax-packages.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Ajax_Shipping_Label' => 'includes/woocommerce/orders/ajax/class-wc-relacoof-ajax-shipping-label.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Ajax_Shipping_Price' => 'includes/woocommerce/orders/ajax/class-wc-relacoof-ajax-shipping-price.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Ajax_Shipping_Return' => 'includes/woocommerce/orders/ajax/class-wc-relacoof-ajax-shipping-return.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Ajax_Way_Bill' => 'includes/woocommerce/orders/ajax/class-wc-relacoof-ajax-way-bill.php',
        // BULK ACTIONS
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Orders_B2c_Bulk_Actions_Manager' => 'includes/woocommerce/orders/bulk/abstract-wc-relacoof-orders-b2c-bulk-actions-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Orders_B2c_Bulk_Auto_Distribute_Manager' => 'includes/woocommerce/orders/bulk/class-wc-relacoof-orders-b2c-bulk-auto-distribute-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Orders_B2c_Bulk_Place_Labels_Manager' => 'includes/woocommerce/orders/bulk/class-wc-relacoof-orders-b2c-bulk-place-labels-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Orders_B2c_Bulk_Print_Shipping_Labels_Manager' => 'includes/woocommerce/orders/bulk/class-wc-relacoof-orders-b2c-bulk-print-shipping-labels-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Orders_B2c_Bulk_Generate_Way_Bills_Manager' => 'includes/woocommerce/orders/bulk/class-wc-relacoof-orders-b2c-bulk-generate-way-bills-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Orders_C2c_Bulk_Actions_Manager' => 'includes/woocommerce/orders/bulk/abstract-wc-relacoof-orders-c2c-bulk-actions-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Orders_C2c_Bulk_Place_Labels_Manager' => 'includes/woocommerce/orders/bulk/class-wc-relacoof-orders-c2c-bulk-place-labels-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Orders_C2c_Bulk_Print_Shipping_Labels_Manager' => 'includes/woocommerce/orders/bulk/class-wc-relacoof-orders-c2c-bulk-print-shipping-labels-manager.php',
        'RelaisColisWoocommerce\\Shipping\\WC_Relacoof_Orders_C2c_Bulk_Auto_Distribute_Manager' => 'includes/woocommerce/orders/bulk/class-wc-relacoof-orders-c2c-bulk-auto-distribute-manager.php',
        // DAOs
        'RelaisColisWoocommerce\\DAO\\WP_Relacoof_Configuration_DAO' => 'includes/dao/class-wp-relacoof-configuration-dao.php',
        'RelaisColisWoocommerce\\DAO\\WP_Relacoof_Information_DAO' => 'includes/dao/class-wp-relacoof-information-dao.php',
        'RelaisColisWoocommerce\\DAO\\WP_Relacoof_Services_DAO' => 'includes/dao/class-wp-relacoof-services-dao.php',
        'RelaisColisWoocommerce\\DAO\\WP_Relacoof_Products_DAO' => 'includes/dao/class-wp-relacoof-products-dao.php',
        'RelaisColisWoocommerce\\DAO\\WP_Relacoof_Tariff_Grids_DAO' => 'includes/dao/class-wp-relacoof-tariff-grids-dao.php',
        'RelaisColisWoocommerce\\DAO\\WP_Relacoof_Orders_Rel_Shipping_Labels_DAO' => 'includes/dao/class-wp-relacoof-orders-rel-shipping-labels-dao.php',
        // CRONS
        'RelaisColisWoocommerce\\Cron\\WP_Relacoof_Cron_Manager' => 'includes/Cron/class-wp-relacoof-cron-manager.php',
    );

    if ( isset( $map[ $class ] ) ) {
        require_once __DIR__.'/'.$map[ $class ];
    }
}, true, false );