<?php
namespace Mewz\WCAS\Aspects\Admin\Settings;

use Mewz\Framework\Base\Aspect;

class InventorySettings extends Aspect
{
	public function __hooks()
	{
		add_filter('woocommerce_get_settings_products', [$this, 'woocommerce_get_settings_products'], 10, 2);
		add_action('woocommerce_admin_field_mewz_wcas_anchor', [$this, 'output_anchor_field']);
	}

	public function woocommerce_get_settings_products($settings, $section)
	{
		if ($section === 'inventory') {
			$settings[] = [
				'id' => 'mewz-wcas-settings',
				'type' => 'mewz_wcas_anchor',
			];

			$settings[] = [
				'title' => __('Attribute Stock', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_options',
				'type' => 'title',
				'desc' => '',
			];

			$settings[] = [
				'title' => __('Modify product stock', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_modify_product_stock',
				'type' => 'select',
				'desc' => __("Set whether attribute stock affects product stock availability. 'Auto' will only modify stock on the frontend, in cron tasks, and during certain actions. 'Everywhere' will modify stock in admin views, and may improve compatibility with other plugins. This setting also affects product stock multipliers.", 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'class' => 'wc-enhanced-select',
				'options' => [
					'auto' => _x('Auto', 'auto preload'),
					'yes' => __('Everywhere', 'woocommerce'),
					'no' => __('No'),
				],
			];

			$settings[] = [
				'title' => __('Sync product visibility', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_sync_product_visibility',
				'type' => 'select',
				'desc' => __("Update visibility taxonomy for top-level products to reflect attribute stock status. This allows product queries to respect attribute stock, for example when using the \"Hide out of stock items\" setting. 'Auto' mirrors the \"Hide out of stock items\" setting.", 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'class' => 'wc-enhanced-select',
				'options' => [
					'auto' => _x('Auto', 'auto preload'),
					'yes' => __('Yes'),
					'no' => __('No'),
				],
			];

			$settings[] = [
				'title' => __('Trigger product stock actions', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_trigger_product_stock_actions',
				'type' => 'select',
				'desc' => __('Trigger product stock change actions when attribute stock changes. Many plugins require these actions to know when stock changes on your site. However, in some cases this might cause issues with certain plugins, or simply not be needed and use unnecessary system resources.', 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'class' => 'wc-enhanced-select',
				'options' => [
					'yes' => __('Yes'),
					'no' => __('No'),
				],
			];

			$settings[] = [
				'title' => trim(__('Allow backorders?', 'woocommerce'), '?¿'),
				'id' => 'mewz_wcas_allow_backorders',
				'type' => 'select',
				'desc' => __('Allow backorders for products using attribute stock. Does not affect products with stock management enabled, or products that are not using attribute stock.', 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'class' => 'wc-enhanced-select',
				'options' => wc_get_product_backorder_options(),
			];

			$settings[] = [
				'title' => __('Product stock format', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_product_stock_format',
				'type' => 'select',
				'desc' => __('Setting this to decimal allows products to use fractional stock quantities. This is required when using decimal product stock multipliers or else quantities will always be rounded down. You can optionally show whole numbers so customers don\'t see fractional stock quantities on the frontend.', 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'class' => 'wc-enhanced-select',
				'options' => [
					'' => __('Default'),
					'decimal' => __('Decimal', 'woocommerce-attribute-stock'),
					'decimal_whole' => __('Decimal (Show whole numbers)', 'woocommerce-attribute-stock'),
				],
			];

			$settings[] = [
				'title' => __('Out of stock variations', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_outofstock_variations',
				'type' => 'select',
				'desc' => __("Select how variation options will be displayed when out of stock. This only applies when the \"Hide out of stock items\" setting is disabled, and affects all variation options site-wide regardless of attribute stock.<br><br> If your products have a lot of variations you'll need to increase the \"Ajax variation threshold\" for this to work.", 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'class' => 'wc-enhanced-select',
				'options' => [
					'outofstock' => __('Out of stock', 'woocommerce'),
					'greyedout' => __('Greyed out', 'woocommerce-attribute-stock'),
					'hidden' => __('Hidden', 'woocommerce'),
				],
			];

			$settings[] = [
				'title' => __('Unmatched "Any" variations', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_unmatched_any_variations',
				'type' => 'select',
				'desc' => __("Select how \"Any\" variation options that don't match attribute stock will be displayed on the frontend. Only affects product variations with \"Any\" selected for some or all attribute terms.", 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'class' => 'wc-enhanced-select',
				'options' => [
					'no' => __('Visible'),
					'outofstock' => __('Out of stock', 'woocommerce'),
					'greyedout' => __('Greyed out', 'woocommerce-attribute-stock'),
					'hidden' => __('Hidden', 'woocommerce'),
				],
			];

			$settings[] = [
				'title' => __('Ajax variation threshold', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_ajax_variation_threshold',
				'type' => 'number',
				'desc' => __('Allows changing the default WooCommerce Ajax Variation Threshold value. When products have more than this number of variations, WooCommerce will load them via Ajax. This is often problematic as it incurs extra loading times and prevents hiding or disabling out-of-stock options. Most servers running WooCommerce can handle a value of at least 300.', 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'placeholder' => '30',
				'css' => 'width: 120px;',
				'custom_attributes' => [
					'step' => '1',
					'min' => '0',
				],
			];

			$settings[] = [
				'title' => __('Components max depth', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_components_max_depth',
				'type' => 'number',
				'desc' => __('The maximum number of levels to query for stock item components. E.g. for A > B > C, component C is at a depth of 2. Try to set this as low as possible to maximize performance. A depth of 0 effectively disables all component stock relationships.', 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'placeholder' => '5',
				'css' => 'width: 120px;',
				'custom_attributes' => [
					'step' => '1',
					'min' => '0',
					'max' => '30', // MySQL join limit
				],
			];

			$settings[] = [
				'id' => 'mewz_wcas_options',
				'type' => 'sectionend',
			];
		}

		return $settings;
	}

	public function output_anchor_field($data)
	{
		echo '<div class="mewz-wcas-anchor" id="' . esc_attr($data['id']) . '"></div>';
	}
}
