/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
(() => {
  if (!window.jQuery) return;
  window.mewzWcas = window.mewzWcas || {};
  mewzWcas.expandProductVariations = expandProductVariations;
  if (mewzWcas.variableData) {
    expandProductVariations(mewzWcas.variableData);

    // Porto theme compatibility
    jQuery(document.body).on('porto_init', (e, wrap) => {
      if (!wrap || !wrap[0] || wrap[0] === document.body || !wrap[0].classList.contains('product')) {
        return;
      }
      let product = wrap[0].querySelector('.variations_form');
      if (product && product.dataset.product_id && product.dataset.product_variations) {
        expandProductVariations(mewzWcas.variableData, [product]);
      }
    });
  }
  function expandProductVariations({
    data: productData,
    images: imageData,
    settings
  }, products) {
    if (products == null) {
      products = document.querySelectorAll('[data-product_id][data-product_variations]');
    } else if (!products || !products.length) {
      return false;
    }
    let expanded = false;
    for (let i = 0; i < products.length; i++) {
      const product = products[i];
      if (!product || !product.dataset || product.dataset.mewzWcasExpanded) {
        continue;
      }
      const productId = +product.dataset.product_id;
      if (productId > 0 && productId in productData) {
        const variations = jQuery(product).data('product_variations');
        if (variations) {
          expandVariations(variations, productData[productId], imageData, settings);
        }
      }
      product.dataset.mewzWcasExpanded = '1';
      expanded = true;
    }
    return expanded;
  }
  function expandVariations(variations, productData, imageData, settings) {
    const {
      vd: variationsData,
      va: variableAttributes,
      pa: productAttributes,
      tm: termMultipliers,
      md: matchData,
      ct: componentTree,
      sh: stockHtml
    } = productData;
    let components = null;
    if (componentTree) {
      components = {
        tree: componentTree,
        items: {}
      };
      for (let i = 0; i < componentTree.length; i++) {
        const comp = componentTree[i];
        components.items[comp.i] = comp;
      }
    }
    for (let v = variations.length - 1; v >= 0; v--) {
      const variation = variations[v];
      if (!variationsData[variation.variation_id]) {
        continue;
      }
      const catchall = !settings.hide_out_of_stock && settings.outofstock_variations === 'outofstock';
      const attributes = getVariationAttributes(variation, variableAttributes, catchall);
      const combinations = getAttributeCombinations(attributes);
      const expandedVariations = [];
      for (let c = 0; c < combinations.length; c++) {
        const expanded = expandVariation(variation, combinations[c], productAttributes, matchData, components, variationsData[variation.variation_id], termMultipliers, stockHtml, imageData, settings);
        if (expanded) {
          expandedVariations.push(expanded);
        }
      }
      if (expandedVariations.length || settings.unmatched_any_variations === 'hidden') {
        expandedVariations.unshift(v, 1);
        Array.prototype.splice.apply(variations, expandedVariations);
      }
    }
  }
  function expandVariation(variation, combination, productAttributes, matchData, components, variationData, termMultipliers, stockHtml, imageData, settings) {
    const data = Object.create(variation);
    const attributes = appendAttributes(combination, productAttributes);
    const limit = matchData ? matchLimit(attributes, matchData, components, variationData, termMultipliers) : {
      qty: null
    };
    const productQty = resolveProductStock(variationData, termMultipliers, attributes, combination);
    if (productQty !== null && (limit.qty === null || productQty < limit.qty)) {
      limit.qty = productQty;
    }
    const backordersAllowed = variationData.b ? true : variation.backorders_allowed;
    if (backordersAllowed !== variation.backorders_allowed) {
      data.backorders_allowed = backordersAllowed;
    }
    if (limit.qty !== null) {
      if (!settings.product_stock_format || settings.product_stock_format === 'decimal_whole') {
        limit.qty >>= 0; // to int
      }

      // limit available stock by attribute stock if backorders not allowed
      if (!backordersAllowed && (variation.max_qty === '' || limit.qty < variation.max_qty)) {
        if (limit.qty <= settings.no_stock_amount || limit.qty < 1) {
          data.max_qty = '';
          data.is_in_stock = false;
        } else {
          data.max_qty = limit.qty;
        }
      }
    } else if (settings.unmatched_any_variations && settings.unmatched_any_variations !== 'no') {
      if (settings.unmatched_any_variations === 'hidden') {
        return false;
      } else if (settings.unmatched_any_variations === 'outofstock') {
        data.max_qty = '';
        data.is_in_stock = false;
        limit.qty = 0;
      } else {
        data.variation_is_active = false;
      }
    }

    // display out of stock variations according to settings
    if (data.is_in_stock === false && !backordersAllowed) {
      if (settings.hide_out_of_stock || settings.outofstock_variations === 'hidden') {
        return false;
      } else if (settings.outofstock_variations === 'greyedout') {
        data.variation_is_active = false;
      }
    }

    // update stock text for stock value limited by attribute stock
    if (limit.qty !== null && stockHtml && (!variationData.m || limit.qty < variationData.q)) {
      const html = getStockHtml(stockHtml, limit.qty, variationData.b || 'no', settings);
      if (html !== variation.availability_html) {
        data.availability_html = html;
      }
    }

    // use stock image for variation
    if (limit.img && imageData && imageData[limit.img] && limit.img !== variation.image_id) {
      data.image_id = limit.img;
      data.image = imageData[limit.img];
    }

    // add combination as attributes
    data.attributes = {};
    for (const attr in combination) {
      data.attributes['attribute_' + attr] = combination[attr];
    }
    return data;
  }
  function getVariationAttributes(variation, variableAttributes, catchAll) {
    const attributes = {};
    for (const attr in variation.attributes) {
      const term = variation.attributes[attr];
      const taxonomy = attr.slice(10);
      if (term === '' && taxonomy in variableAttributes) {
        attributes[taxonomy] = variableAttributes[taxonomy];
        if (catchAll && attributes[taxonomy].indexOf('') === -1) {
          attributes[taxonomy].push('');
        }
      } else {
        attributes[taxonomy] = [term];
      }
    }
    return attributes;
  }
  function appendAttributes(attributes, append) {
    attributes = {
      ...attributes
    };
    for (const attr in append) {
      const terms = append[attr];
      if (terms.length === 1) {
        attributes[attr] = terms[0];
      } else {
        attributes[attr] = terms;
      }
    }
    return attributes;
  }
  function matchLimit(attributes, matchData, components, variationData, termMultipliers) {
    let limitQty = null;
    let imageId = null;
    const use = {};
    for (let i = 0; i < matchData.length; i++) {
      const {
        i: id,
        r: rules,
        q: quantity,
        m: multiplex,
        l: lockMultipliers,
        g: img
      } = matchData[i];
      let multiplier = null;
      for (let r = 0; r < rules.length; r++) {
        const rule = rules[r];
        if (!ruleHasAttributes(rule, attributes)) {
          continue;
        }

        // a negative multiplier is a stop rule
        if (rule.x < 0) break;
        const x = resolveRuleMultiplier(rule, variationData, attributes, termMultipliers, lockMultipliers);
        multiplier = multiplier === null ? x : multiplier + x;

        // only multiplex items match more than one rule
        if (!multiplex) break;
      }
      if (multiplier !== null) {
        const matchLimit = multiplier > 0 ? quantity / multiplier : 0;
        if (limitQty === null || matchLimit < limitQty) {
          limitQty = matchLimit;
        }
        if (components) {
          use[id] = multiplier;
        }
        if (imageId === null && img) {
          imageId = img;
        }
      }
    }
    if (components) {
      const compLimit = calcComponentLimit(components, use);
      if (compLimit !== false) {
        limitQty = compLimit;
      }
    }
    return {
      qty: limitQty,
      img: imageId
    };
  }
  function calcComponentLimit(components, use) {
    const tree = [];
    const children = {};
    let hasComponents = false;

    // build subtree for use set
    for (let i = 0; i < components.tree.length; i++) {
      const comp = components.tree[i];
      if (children[comp.i]) {
        comp.u = 0;
        comp.s = comp.q;
        hasComponents = true;
      } else if (comp.i in use) {
        comp.u = use[comp.i] || 1;
        comp.s = use[comp.i] ? comp.q : 0;
      } else {
        continue;
      }
      if (comp.c) {
        for (let c = 0; c < comp.c.length; c++) {
          children[comp.c[c][0]] = true;
        }
      }
      tree.push(comp);
    }
    if (!hasComponents) {
      return false;
    }

    // calculate available stock quantity from component tree
    let limitQty = 0;
    main: for (;;) {
      let deductQty = Infinity;
      let deductItems = [];
      for (let i = 0; i < tree.length; i++) {
        const node = tree[i];
        if (node.u <= 0) {
          continue;
        }
        if (node.s >= node.u) {
          deductItems.push(node);
          const max = node.s / node.u >> 0;
          if (max < deductQty) {
            deductQty = max;
          }
        } else if (node.c) {
          let childUse;
          if (node.s > 0) {
            deductQty = 1;
            deductItems.push(node);
            childUse = node.u - node.s;
            node.u = node.s;
          } else {
            childUse = node.u;
            node.u = 0;
          }
          for (let i = 0; i < node.c.length; i++) {
            const child = node.c[i];
            const childQty = child[1] != null ? child[1] : 1;
            components.items[child[0]].u += childUse * childQty;
          }
        } else {
          // we've reached a leaf with no more stock, so we're done calculating
          break main;
        }
      }
      if (deductItems.length) {
        // apply the deductions
        for (let i = 0; i < deductItems.length; i++) {
          deductItems[i].s -= deductItems[i].u * deductQty;
        }
        limitQty += deductQty;
      } else {
        // prevent infinite loop if all items have 'use' = 0
        break;
      }
    }
    return limitQty;
  }
  function ruleHasAttributes(rule, attributes) {
    for (let attr in rule.a) {
      const term = rule.a[attr];
      const hasMatch = attr in attributes && (term === '' || term === attributes[attr] || Array.isArray(attributes[attr]) && attributes[attr].indexOf(term) !== -1);

      // if any rule attributes *don't* match the product attributes, then no match
      if (!hasMatch) {
        return false;
      }
    }
    return true;
  }
  function resolveRuleMultiplier(rule, variationData, attributes, termMultipliers, lockMultipliers) {
    // product multiplier override takes priority
    if (variationData.ax != null && !lockMultipliers) {
      return variationData.ax;
    }

    // then stock multiplier set on the attribute stock rule
    if (rule.x != null) {
      return rule.x;
    }

    // finally, check if we can match a term default multiplier
    if (termMultipliers) {
      for (let i = 0; i < termMultipliers.length; i++) {
        const [taxonomy, xterms] = termMultipliers[i];
        if (!(taxonomy in rule.a)) {
          continue;
        }
        let terms;
        if (typeof attributes[taxonomy] === 'string') {
          terms = [attributes[taxonomy]];
        } else if (typeof rule.a[taxonomy] === 'string') {
          terms = [rule.a[taxonomy]];
        } else if (Array.isArray(attributes[taxonomy]) && attributes[taxonomy].length) {
          terms = attributes[taxonomy];
        } else if (Array.isArray(rule.a[taxonomy]) && attributes[taxonomy].length) {
          terms = rule.a[taxonomy];
        }
        if (terms) {
          for (let t = 0; t < terms.length; t++) {
            const term = terms[t];
            if (term in xterms) {
              return xterms[term];
            }
          }
        }
        break;
      }
    }

    // if no multiplier then it's just 1
    return 1;
  }
  function resolveProductStock(variationData, termMultipliers, attributes, combination) {
    if (!variationData.m) {
      return null;
    }
    let multiplier = 1;
    if (variationData.px != null) {
      multiplier = variationData.px;
    } else if (termMultipliers) {
      if (variationData.m !== 'parent') {
        // only inherit term multipliers from non-variation attributes if using product-level stock
        attributes = combination;
      }
      for (let i = 0; i < termMultipliers.length; i++) {
        const [taxonomy, xterms] = termMultipliers[i];
        if (!(taxonomy in attributes) || attributes[taxonomy] === '') {
          continue;
        }
        let terms;
        if (typeof attributes[taxonomy] === 'string') {
          terms = [attributes[taxonomy]];
        } else if (Array.isArray(attributes[taxonomy]) && attributes[taxonomy].length) {
          terms = attributes[taxonomy];
        }
        if (terms) {
          for (let t = 0; t < terms.length; t++) {
            const term = terms[t];
            if (term in xterms) {
              multiplier = xterms[term];
              break;
            }
          }
        }
        break;
      }
    }
    let stockQty = variationData.q;
    if (multiplier !== 1) {
      stockQty = multiplier > 0 ? stockQty / multiplier : 0;
    }
    return stockQty;
  }
  function getStockHtml(stockHtml, quantity, backorders, settings) {
    let html;
    if (quantity <= settings.no_stock_amount || quantity < 1) {
      html = stockHtml.out[backorders];
    } else if (quantity <= settings.low_stock_amount) {
      html = stockHtml.low[backorders];
    } else {
      html = stockHtml.in[backorders];
    }
    return html.replace('%s', quantity);
  }
  function getAttributeCombinations(attributes) {
    let result = [{}];
    for (const key in attributes) {
      const terms = attributes[key];
      const append = [];
      for (let i = 0; i < result.length; i++) {
        let product = result[i];
        for (let j = 0; j < terms.length; j++) {
          product = {
            ...product
          };
          product[key] = terms[j];
          append.push(product);
        }
      }
      result = append;
    }
    return result;
  }
})();
/******/ })()
;