<?php

class LpcColissimoStatus extends LpcComponent {

    // phpcs:disable WordPress.Arrays.ArrayDeclarationSpacing.AssociativeArrayFound
    protected $status_list = array(
        0   => ['clp' => 'AACALI', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'La livraison de votre colis dans un espace Cityssimo est impossible, le destinataire n\'est pas abonné à ce service.'],
        1   => ['clp' => 'AACEDI', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Le colis ne peut être livré dans un automate de retrait Cityssimo en raison de l\'absence de coordonnées du destinataire. Le colis sera retourné à l\'expéditeur. '],
        2   => ['clp' => 'AARALI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        3   => ['clp' => 'AARAVI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est à disposition dans le point de retrait choisi. Il est à retirer pendant 10 jours ouvrables sur présentation d\'une pièce d\'identité et de l\'avis d\'instance.'],
        4   => ['clp' => 'AARBPR', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est à disposition dans le point de retrait choisi. Il est à retirer pendant 10 jours ouvrables sur présentation d\'une pièce d\'identité et du bon de retrait.'],
        5   => ['clp' => 'AARBRX', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est disponible dans un point de retrait différent de celui choisi initialement. Le destinataire en a été informé par email. Le colis est à retirer pendant 10 jours ouvrables sur présentation d\'une pièce d\'identité et du bon de retrait. '],
        6   => ['clp' => 'AARCFM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est arrivé sur son site de distribution'],
        7   => ['clp' => 'AARDES', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est en cours d\'acheminement.'],
        8   => ['clp' => 'AARDOU', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est en cours de dédouanement.'],
        9   => ['clp' => 'AAREXC', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        10  => ['clp' => 'AAREXP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est arrivé dans le pays de destination'],
        11  => ['clp' => 'AARIMP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est arrivé en France'],
        12  => ['clp' => 'AARJPO', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est arrivé sur son site de distribution'],
        13  => ['clp' => 'AARLIB', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis a subi un incident. Nous vous remercions de prendre contact avec notre service clients, au 3631 pour les clients Particuliers auprès de vos interlocuteurs habituels pour les clients Entreprises.'],
        14  => ['clp' => 'AARREL', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est disponible dans le point de retrait sélectionné. La date limite de retrait du colis a été précisée au destinataire par email.'],
        15  => ['clp' => 'AARREM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        16  => ['clp' => 'AARREX', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est réexpédié à la demande du destinataire vers l\'adresse de son choix.'],
        17  => ['clp' => 'AARRLX', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est disponible dans un point de retrait différent de celui choisi initialement. Le destinataire en a été informé par email. Le colis est à retirer pendant 10 jours ouvrables sur présentation d\'une pièce d\'identité et du bon de retrait. '],
        18  => ['clp' => 'AARTER', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis a subi une erreur de tri, il a maintenant repris son acheminement.'],
        19  => ['clp' => 'AARTRA', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est en cours d\'acheminement.'],
        20  => ['clp' => 'ACDBRS', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        21  => ['clp' => 'ACDNPL', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        22  => ['clp' => 'ACDPNT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        23  => ['clp' => 'ACPINF', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        24  => ['clp' => 'ACPINT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        25  => ['clp' => 'AEC', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        26  => ['clp' => 'AECCFM', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        27  => ['clp' => 'AECCLI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        28  => ['clp' => 'AECCOU', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est pris en charge par La Poste. Il est en cours d\'acheminement.'],
        29  => ['clp' => 'AECEXC', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        30  => ['clp' => 'AECEXP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est en cours d\'acheminement.'],
        31  => ['clp' => 'AECIMP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est arrivé en France'],
        32  => ['clp' => 'AECIND', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        33  => ['clp' => 'AECMAN', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        34  => ['clp' => 'AECPDS', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Non affiché'],
        35  => ['clp' => 'AECPIS', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        36  => ['clp' => 'AECPNC', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        37  => ['clp' => 'AECPRE', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est pris en charge par La Poste, il est en cours d\'acheminement.'],
        38  => ['clp' => 'AECSEC', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        39  => ['clp' => 'AECS3C', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        40  => ['clp' => 'AECTRC', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        41  => ['clp' => 'AECTRI', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        42  => ['clp' => 'AEC128', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        43  => ['clp' => 'ANNULE', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        44  => ['clp' => 'AVOEXT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        45  => ['clp' => 'CCDSUP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        46  => ['clp' => 'CHGCFM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        47  => ['clp' => 'COMLDF', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        48  => ['clp' => 'COMLNA', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        49  => ['clp' => 'CRBREC', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        50  => ['clp' => 'CRBTRT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        51  => ['clp' => 'DEPCDR', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        52  => ['clp' => 'DEPGUI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis a été déposé dans un point postal.'],
        53  => ['clp' => 'DEPHLD', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis a été déposé après l\'heure limite de dépôt. Il sera expédié dès le prochain jour ouvré.'],
        54  => ['clp' => 'DEPIMP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis a été déposé dans un point postal.'],
        55  => ['clp' => 'DEPREL', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis a été déposé dans un point postal.'],
        56  => ['clp' => 'DEPSIO', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis a été déposé dans un point postal.'],
        57  => ['clp' => 'DIFDIL', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        58  => ['clp' => 'DOUAGV', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est en cours de dédouanement.'],
        59  => ['clp' => 'DOUANN', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        60  => ['clp' => 'DOUCOI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retenu par nos services pour un problème de certificat d\'origine. Le destinataire du colis va être contacté.'],
        61  => ['clp' => 'DOUCOM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retenu par nos services pour un problème de certificat d\'origine. Le destinataire du colis va être contacté.'],
        62  => ['clp' => 'DOUCRR', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retenu par nos services pour un problème de certificat de retour. Le destinataire du colis va être contacté.'],
        63  => ['clp' => 'DOUDDI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retenu par nos services pour un problème de déclaration douanière. Le destinataire du colis va être contacté.'],
        64  => ['clp' => 'DOUDDM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retenu par nos services pour un problème de déclaration douanière. Le destinataire du colis va être contacté.'],
        65  => ['clp' => 'DOUDOU', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est en cours de dédouanement.'],
        66  => ['clp' => 'DOUDVR', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retenu par nos services pour un problème de facture.Le destinataire du colis va être contacté.'],
        67  => ['clp' => 'DOUEXI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retenu par nos services pour un problème de déclaration douanière. Le destinataire du colis va être contacté.'],
        68  => ['clp' => 'DOUEXP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est en cours d\'acheminement.'],
        69  => ['clp' => 'DOUFCI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retenu par nos services pour un problème de facture. Le destinataire du colis va être contacté.'],
        70  => ['clp' => 'DOUFCM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retenu par nos services pour un problème de facture. Le destinataire du colis va être contacté.'],
        71  => ['clp' => 'DOUFTD', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        72  => ['clp' => 'DOUIDD', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retenu par nos services pour un problème de déclaration douanière. Le destinataire du colis va être contacté.'],
        73  => ['clp' => 'DOUIIR', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retenu par nos services pour un problème de déclaration douanière. Le destinataire du colis va être contacté.'],
        74  => ['clp' => 'DOUNIR', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retenu par nos services pour un problème de facture. Le destinataire du colis va être contacté.'],
        75  => ['clp' => 'DOUPAR', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis a fait l\'objet d\'une saisie partielle par les autorités douanières, il est remis en acheminement.'],
        76  => ['clp' => 'DOUPRO', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Le contenu de votre colis est prohibé, il ne pourra pas être livré à son destinataire.'],
        77  => ['clp' => 'DOURES', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retenu par nos services pour un problème de licence d\'importation. Le destinataire du colis va être contacté.'],
        78  => ['clp' => 'DOUTAX', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est en cours d\'acheminement et sera livré contre paiement d\'une taxe douanière.'],
        79  => ['clp' => 'DOUVIS', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis a été inspecté par les autorités douanières, il est remis en acheminement.'],
        80  => ['clp' => 'DSCCLO', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Le dossier est clôturé par le Service Client.'],
        81  => ['clp' => 'DSCIND', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        82  => ['clp' => 'DSCMAJ', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        83  => ['clp' => 'DSCOUV', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Un dossier est ouvert par le Service Client.'],
        84  => ['clp' => 'ECHANN', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis récupéré par notre agence n\'est pas conforme. Il va être retourné à l\'expéditeur.'],
        85  => ['clp' => 'ECHCEX', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis récupéré par notre agence n\'est pas conforme. Il va être retourné à l\'expéditeur.'],
        86  => ['clp' => 'ECHCFM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis a été récupéré dans votre boite aux lettres.'],
        87  => ['clp' => 'ECHCNS', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        88  => ['clp' => 'ECHDID', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis récupéré par notre agence n\'est pas conforme. Il va être retourné à l\'expéditeur.'],
        89  => ['clp' => 'ECHMQT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis récupéré par notre agence n\'est pas conforme. Il va être retourné à l\'expéditeur.'],
        90  => ['clp' => 'ECHNCF', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis récupéré par notre agence n\'est pas conforme. Il va être retourné à l\'expéditeur.'],
        91  => ['clp' => 'ECHRCC', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        92  => ['clp' => 'ECHREL', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        93  => ['clp' => 'EDIMQT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        94  => ['clp' => 'EDINCG', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        95  => ['clp' => 'EMADFT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        96  => ['clp' => 'EMLCAD', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        97  => ['clp' => 'EMLCFM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis va être récupéré dans votre boite aux lettres aujourd\'hui.'],
        98  => ['clp' => 'EMLRES', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        99  => ['clp' => 'EMLVAL', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        100 => ['clp' => 'ENEAVA', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être récupéré car l\'emballage était insuffisant ou n\'était pas fermé. Vous disposez de 7 jours à compter de la date d\'achat pour le déposer en bureau de poste.'],
        101 => ['clp' => 'ENECAD', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        102 => ['clp' => 'ENECNS', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        103 => ['clp' => 'ENEDAF', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être récupéré car la boite aux lettres était introuvable ou non accessible. Vous disposez de 7 jours à compter de la date d\'achat pour le déposer en bureau de Poste.'],
        104 => ['clp' => 'ENEDOC', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être récupéré car le numéro indiqué sur l\'étiquette ne correspondait pas à celui du colis à récupérer. Vous disposez de 7 jours à compter de la date d\'achat pour le déposer en bureau de poste.'],
        105 => ['clp' => 'ENEFCO', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        106 => ['clp' => 'ENEFMA', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        107 => ['clp' => 'ENEMQT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être récupéré car il n\'était pas présent dans la boite aux lettres. Vous disposez de 7 jours à compter de la date d\'achat pour le déposer en bureau de Poste.'],
        108 => ['clp' => 'ENENCF', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être récupéré car il ne comportait pas d\'étiquette d\'affranchissement. Vous disposez de 7 jours à compter de la date d\'achat pour le déposer en bureau de poste.'],
        109 => ['clp' => 'ENEPRE', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        110 => ['clp' => 'ENEREL', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        111 => ['clp' => 'ENERES', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        112 => ['clp' => 'EPCCFM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        113 => ['clp' => 'EPCCOM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        114 => ['clp' => 'EPCMQT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        115 => ['clp' => 'EPCREL', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        116 => ['clp' => 'FENDES', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'L\'emballage de votre colis a été renforcé pour assurer sa livraison.'],
        117 => ['clp' => 'FENLIB', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        118 => ['clp' => 'FENRET', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Incident sur votre colis: celui-ci est renvoyé à l\'expéditeur et nous vous prions d\'accepter nos excuses.'],
        119 => ['clp' => 'IGNORE', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        120 => ['clp' => 'INVEXT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        121 => ['clp' => 'LCDECP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        122 => ['clp' => 'LCDEXP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        123 => ['clp' => 'LCDPAE', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        124 => ['clp' => 'LCDSUP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        125 => ['clp' => 'LCQENC', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        126 => ['clp' => 'LCQENV', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        127 => ['clp' => 'LCQNEC', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        128 => ['clp' => 'LCQNEM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        129 => ['clp' => 'LCQPER', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        130 => ['clp' => 'LCQREF', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        131 => ['clp' => 'LIVAVI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être livré, il sera mis à disposition dans le bureau de Poste du destinataire.'],
        132 => ['clp' => 'LIVBPO', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_DELIVERED, 'label' => 'Votre colis est à disposition en boîte postale'],
        133 => ['clp' => 'LIVCFM', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_DELIVERED, 'label' => 'Votre colis est livré.'],
        134 => ['clp' => 'LIVCIT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est à disposition dans le point de retrait choisi. Il est à retirer pendant 10 jours ouvrables muni de votre numéro de retrait.'],
        135 => ['clp' => 'LIVDIV', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_DELIVERED, 'label' => 'Votre colis est livré mais le destinataire a signalé un emballage modérément dégradé.'],
        136 => ['clp' => 'LIVECH', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        137 => ['clp' => 'LIVEXP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est livré à l\'expéditeur suite à un retour.'],
        138 => ['clp' => 'LIVGAR', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_DELIVERED, 'label' => 'Votre colis a été livré au gardien.'],
        139 => ['clp' => 'LIVRCA', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_DELIVERED, 'label' => 'Votre colis est livré mais le destinataire a signalé un emballage fortement dégradé.'],
        140 => ['clp' => 'LIVRCC', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_DELIVERED, 'label' => 'Votre colis est livré mais le destinataire a signalé un emballage fortement dégradé.'],
        141 => ['clp' => 'LIVRDV', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est livré.'],
        142 => ['clp' => 'LIVREL', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est en cours de livraison en point de retrait.'],
        143 => ['clp' => 'LIVRTI', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_DELIVERED, 'label' => 'Votre colis a été livré au gardien ou à un voisin.'],
        144 => ['clp' => 'LIVVOI', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_DELIVERED, 'label' => 'Votre colis est livré au voisin indiqué sur l\'avis déposé dans la boîte aux lettres du destinataire.'],
        145 => ['clp' => 'LIVVPC', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est livré.'],
        146 => ['clp' => 'MLVDFT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => ''],
        147 => ['clp' => 'MLVEXP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis a quitté le pays d\'origine.'],
        148 => ['clp' => 'MLVIMP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis a quitté le pays d\'origine.'],
        149 => ['clp' => 'MLVTRA', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est en cours d\'acheminement.'],
        150 => ['clp' => 'MLVTRD', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis a quitté le pays d\'origine.'],
        151 => ['clp' => 'NADDES', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'La notification de mise à disposition a été transmise au destinataire'],
        152 => ['clp' => 'NADNOK', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        153 => ['clp' => 'PABDES', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'L\'emballage de votre colis a été renforcé pour assurer sa livraison'],
        154 => ['clp' => 'PABLIB', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        155 => ['clp' => 'PABRET', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Incident sur votre colis: celui-ci est renvoyé à l\'expéditeur et nous vous prions d\'accepter nos excuses.'],
        156 => ['clp' => 'PCHBOR', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        157 => ['clp' => 'PCHCEI', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est pris en charge par La Poste. Il est en cours d\'acheminement.'],
        158 => ['clp' => 'PCHCFM', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        159 => ['clp' => 'PCHCLI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est prêt à être expédié, il va être remis à La Poste.'],
        160 => ['clp' => 'PCHDFT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est prêt à être expédié, il va être remis à La Poste.'],
        161 => ['clp' => 'PCHDIS', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        162 => ['clp' => 'PCHECH', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Non affiché'],
        163 => ['clp' => 'PCHEXC', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        164 => ['clp' => 'PCHEXP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est pris en charge. Il est en cours d\'acheminement dans le pays de destination.'],
        165 => ['clp' => 'PCHEXT', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        166 => ['clp' => 'PCHIMP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est en cours d\'acheminement.'],
        167 => ['clp' => 'PCHIND', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        168 => ['clp' => 'PCHINJ', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        169 => ['clp' => 'PCHJPO', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        170 => ['clp' => 'PCHMAN', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        171 => ['clp' => 'PCHMQT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est prêt à être expédié, il va être remis à La Poste.'],
        172 => ['clp' => 'PCHPDS', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        173 => ['clp' => 'PCHPIS', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        174 => ['clp' => 'PCHPNC', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        175 => ['clp' => 'PCHPRE', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        176 => ['clp' => 'PCHREC', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        177 => ['clp' => 'PCHSEC', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        178 => ['clp' => 'PCHSVI', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        179 => ['clp' => 'PCHS3C', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        180 => ['clp' => 'PCHTRI', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        181 => ['clp' => 'PCH128', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement.'],
        182 => ['clp' => 'PREAVI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        183 => ['clp' => 'PRELIV', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est en préparation pour la livraison.'],
        184 => ['clp' => 'PRELIZ', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        185 => ['clp' => 'QDICFM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera présenté le prochain jour ouvré et nécessite une remise en mains propres. Si vous êtes absent, vous pouvez nous donner vos instructions sur wwww.colissimo.fr/monchoix.'],
        186 => ['clp' => 'QINDIV', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Une demande est transmise au Service Client'],
        187 => ['clp' => 'QINEXP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Une demande de vérification de délai est transmise au Service Client'],
        188 => ['clp' => 'QINNCF', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        189 => ['clp' => 'RCDDVY', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis est réacheminé vers un autre site de distribution en raison d\'un défaut d\'adressage.'],
        190 => ['clp' => 'RCDNPA', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être livré, il est retourné à l\'expéditeur.'],
        191 => ['clp' => 'RCDREA', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être livré, il est retourné à l\'expéditeur.'],
        192 => ['clp' => 'RCDREL', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur suite à un refus du destinataire.'],
        193 => ['clp' => 'RCDRET', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être livré, il est retourné à l\'expéditeur.'],
        194 => ['clp' => 'RDVABS', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis n\'a pu être livré car le destinataire était absent. Il sera prochainement recontacté pour convenir d\'un nouveau rendez-vous.'],
        195 => ['clp' => 'RDVAIN', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis n\'a pas pu être livré sur rendez-vous. Le destinataire doit choisir une date de livraison.'],
        196 => ['clp' => 'RDVANN', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        197 => ['clp' => 'RDVCFM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera livré sur rendez-vous à la date choisie par le destinataire.'],
        198 => ['clp' => 'RDVCR1', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera livré sur rendez-vous à la date choisie par le destinataire : ce jour entre 17h et 19h.'],
        199 => ['clp' => 'RDVCR2', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera livré sur rendez-vous à la date choisie par le destinataire : ce jour entre 18h et 20h.'],
        200 => ['clp' => 'RDVCR3', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera livré sur rendez-vous à la date choisie par le destinataire : ce jour entre 19h et 21h.'],
        201 => ['clp' => 'RDVDEM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera livré sur rendez-vous à la date choisie par le destinataire.'],
        202 => ['clp' => 'RDVINC', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis n\'a pas pu être livré sur rendez-vous. Le destinataire sera prochainement recontacté.'],
        203 => ['clp' => 'RDVINS', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis doit être livré sur rendez-vous, le destinataire sera prochainement contacté pour choisir la date.'],
        204 => ['clp' => 'RDVMA1', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera livré sur rendez-vous à la date choisie par le destinataire : ce jour entre 17h et 19h.'],
        205 => ['clp' => 'RDVMA2', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera livré sur rendez-vous à la date choisie par le destinataire : ce jour entre 18h et 20h.'],
        206 => ['clp' => 'RDVMA3', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera livré sur rendez-vous à la date choisie par le destinataire : ce jour entre 19h et 21h.'],
        207 => ['clp' => 'RDVPRI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est prêt à être livré sur rendez-vous. Le destinataire doit choisir le créneau horaire qui lui convient.'],
        208 => ['clp' => 'RDVREP', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis est prêt à être livré sur rendez-vous. Nous sommes en attente de votre choix de créneau horaire.'],
        209 => ['clp' => 'RDVSEC', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est prêt à être livré sur rendez-vous. Nous sommes en attente de votre choix de créneau horaire.'],
        210 => ['clp' => 'RDVTER', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est prêt à être livré sur rendez-vous. Nous sommes en attente de votre choix de créneau horaire.'],
        211 => ['clp' => 'RECALI', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis n\'a pas pu être livré dans l\'espace Cityssimo suite à une erreur sur votre compte abonné'],
        212 => ['clp' => 'REFALI', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'La livraison de votre colis dans l\'espace Cityssimo est impossible, il est retourné à l\'expéditeur.'],
        213 => ['clp' => 'REFCDS', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'L\'emballage de votre colis a été renforcé pour en assurer sa livraison. Il est en cours d\'acheminement.'],
        214 => ['clp' => 'REFCEX', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis est retourné à l\'expéditeur suite à un incident.'],
        215 => ['clp' => 'REFDDS', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'L\'emballage de votre colis a été renforcé pour en assurer sa livraison. Il est en cours d\'acheminement.'],
        216 => ['clp' => 'REFDEX', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis est retourné à l\'expéditeur suite à un incident.'],
        217 => ['clp' => 'REFISO', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis et/ou son étiquette sont endommagés. Votre colis est en cours de traitement '],
        218 => ['clp' => 'REFLIB', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Non affiché'],
        219 => ['clp' => 'REFREN', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Non affiché'],
        220 => ['clp' => 'REFSTP', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Non affiché'],
        221 => ['clp' => 'REMTRA', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        222 => ['clp' => 'RENACO', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'La livraison de votre colis dans un espace Cityssimo est impossible. Le compte abonné est inactif ou résilié. Le colis est rééxpédié au domicile du destinataire.'],
        223 => ['clp' => 'RENACP', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis ne peut être livré ce jour, l\'accès à l\'adresse de livraison étant impossible. Il sera remis en livraison au plus tôt.'],
        224 => ['clp' => 'RENAEP', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'L\'espace Colis Cityssimo est momentanément hors service, le colis est rééxpédié au domicile du destinataire.'],
        225 => ['clp' => 'RENAIN', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis ne peut actuellement être livré au destinataire, l\'adresse de livraison étant incomplète. Le destinataire peut contacter notre service clients pour apporter les compléments nécessaires, en cliquant sur Nous contacter en ligne.'],
        226 => ['clp' => 'RENALI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Après expiration du délai de garde dans l\'espace Cityssimo, votre colis est retourné à l\'expéditeur.'],
        227 => ['clp' => 'RENAPR', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Le colis est disponible dans le Point de Retrait communiqué au destinataire.'],
        228 => ['clp' => 'RENARV', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pu être livré car le destinataire était absent. Il sera remis en livraison le prochain jour ouvré. Le destinataire peut se rendre sur http://www.colissimo.fr/monchoix pour donner de nouvelles instructions.'],
        229 => ['clp' => 'RENAVA', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur suite à un refus du destinataire.'],
        230 => ['clp' => 'RENAVI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être livré, il sera mis à disposition dans le bureau de Poste du destinataire.'],
        231 => ['clp' => 'RENBEC', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur.'],
        232 => ['clp' => 'RENCAD', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis ne peut actuellement être livré à son destinataire, l\'adresse de livraison étant incomplète. Le destinataire peut contacter notre service clients pour apporter les compléments nécessaires, en cliquant sur Nous contacter en ligne.'],
        233 => ['clp' => 'RENCND', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => ''],
        234 => ['clp' => 'RENCRV', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pu être livré. Le destinataire peut nous faire part de son choix de livraison aujourd\'hui jusqu\'à minuit en cliquant ici.'],
        235 => ['clp' => 'RENDES', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur suite à un refus du destinataire.'],
        236 => ['clp' => 'RENDET', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis est déterioré et ne peut être livré dans un espace Cityssimo, il est rééxpédié au domicile du destinataire.'],
        237 => ['clp' => 'RENDID', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas été retiré dans les délais impartis , il est retourné à l\'expéditeur.'],
        238 => ['clp' => 'RENDOC', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur car la facture nécessaire au traitement douanier n\'a pas été reçue dans les délais (21 jours). '],
        239 => ['clp' => 'RENECO', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Le colis ne peut être livré dans un automate de retrait Cityssimo. Le colis sera adressé au domicile du Destinataire.'],
        240 => ['clp' => 'RENEDI', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Le colis ne peut être livré dans un automate de retrait Cityssimo en raison de l\'absence de coordonnées du destinataire. Le colis sera retourné à l\'expéditeur.'],
        241 => ['clp' => 'RENEXP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être livré, il est retourné à l\'expéditeur.'],
        242 => ['clp' => 'RENFCO', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis n\'a pas pu être livré ce jour, le point de retrait choisi étant fermé. Il sera remis en livraison au plus tôt.'],
        243 => ['clp' => 'RENGUI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être livré, il sera mis à disposition dans le bureau de Poste du destinataire.'],
        244 => ['clp' => 'RENHER', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur.'],
        245 => ['clp' => 'RENINC', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis n\'est pas compatible avec une livraison dans un espace Cityssimo, il est rééxpédié au domicile du destinataire'],
        246 => ['clp' => 'RENNPA', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être livré, il est retourné à l\'expéditeur.'],
        247 => ['clp' => 'RENNRV', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être livré car le destinataire était absent. Il sera remis en livraison le prochain jour ouvré.'],
        248 => ['clp' => 'RENNRZ', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        249 => ['clp' => 'RENOUV', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur suite à un refus du destinataire.'],
        250 => ['clp' => 'RENPPL', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Le colis ne peut être livré dans un automate de retrait Cityssimo. Le colis sera adressé au domicile du Destinataire.'],
        251 => ['clp' => 'RENRDV', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est en préparation pour la livraison.'],
        252 => ['clp' => 'RENREF', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'L\'emballage de votre colis a été renforcé pour en assurer sa livraison. Il est en cours d\'acheminement.'],
        253 => ['clp' => 'RENREL', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis ne peut être livré dans le point de retrait choisi. Le destinataire sera informé du nouveau point de livraison.'],
        254 => ['clp' => 'RENRES', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis ne peut être livré ce jour. Il sera remis en livraison au plus tôt.'],
        255 => ['clp' => 'RENREX', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est réexpédié à la demande du destinataire vers l\'adresse de son choix.'],
        256 => ['clp' => 'RENRPE', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur.'],
        257 => ['clp' => 'RENRPP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur.'],
        258 => ['clp' => 'RENRPR', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est redirigé vers un point de retrait, un courrier informatif est envoyé au destinataire.'],
        259 => ['clp' => 'RENSCR', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => ''],
        260 => ['clp' => 'RENSHD', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur suite à un refus du destinataire.'],
        261 => ['clp' => 'RENSNC', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur suite à un refus du destinataire.'],
        262 => ['clp' => 'RENSRB', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur suite à un refus du destinataire.'],
        263 => ['clp' => 'RENSRV', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        264 => ['clp' => 'RENTAX', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur.'],
        265 => ['clp' => 'RENVLM', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => ''],
        266 => ['clp' => 'RENVOL', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Le colis ne peut être livré dans l\'automate de retrait Cityssimo : sa taille n\'est pas adaptée au casier. Il sera adressé au domicile du Destinataire.'],
        267 => ['clp' => 'RENXXX', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur suite à un refus du destinataire.'],
        268 => ['clp' => 'RSDANO', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        269 => ['clp' => 'RSDBPI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera mis à disposition au point de retrait choisi par le destinataire.'],
        270 => ['clp' => 'RSDINS', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        271 => ['clp' => 'RSDMQT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        272 => ['clp' => 'RSDNRV', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera livré sur rendez-vous à la date choisie par le destinataire.'],
        273 => ['clp' => 'RSTACP', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis ne peut être livré ce jour, l\'accès à l\'adresse de livraison étant impossible. Il sera remis en livraison au plus tôt.'],
        274 => ['clp' => 'RSTAVI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être livré, il sera mis à disposition dans le bureau de Poste habituel du destinataire.'],
        275 => ['clp' => 'RSTCAD', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis ne peut actuellement être livré à son destinataire, l\'adresse de livraison étant incomplète. Le destinataire peut contacter notre service clients pour apporter les compléments nécessaires, en cliquant sur Nous contacter en ligne.'],
        276 => ['clp' => 'RSTEMP', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Non affiché'],
        277 => ['clp' => 'RSTPRO', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Le contenu de votre colis est prohibé, il ne pourra pas être livré à son destinataire.'],
        278 => ['clp' => 'RSTREF', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Non affiché'],
        279 => ['clp' => 'RSTRES', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis ne peut être livré ce jour. Il sera remis en livraison au plus tôt.'],
        280 => ['clp' => 'RSTTAF', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_DELIVERED, 'label' => 'votre colis est en attente du prochain acheminement vers sa destination'],
        281 => ['clp' => 'RSTTRI', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Non affiché'],
        282 => ['clp' => 'RSTZNL', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'La livraison à domicile est actuellement suspendue sur ce secteur. Votre colis sera mis à disposition dans le bureau de poste habituel du destinataire.'],
        283 => ['clp' => 'SCCDES', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Suite à un incident, votre colis est en cours d\'acheminement avec un nouveau numéro.'],
        284 => ['clp' => 'SCCDID', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        285 => ['clp' => 'SCCEXP', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Suite à un incident, votre colis est retourné à l\'expéditeur avec un nouveau numéro.'],
        286 => ['clp' => 'SCLBRI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        287 => ['clp' => 'SCLSCL', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        288 => ['clp' => 'SOLDDR', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis a été saisi par les autorités douanières, il ne sera pas livré à son destinataire.'],
        289 => ['clp' => 'SOLDOC', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis a subi un incident. Nous vous remercions de prendre contact avec notre service clients, au 3631 pour les clients Particuliers auprès de vos interlocuteurs habituels pour les clients Entreprises.'],
        290 => ['clp' => 'SOLMAR', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis a subi un incident. Nous vous remercions de prendre contact avec notre service clients, au 3631 pour les clients Particuliers auprès de vos interlocuteurs habituels pour les clients Entreprises.'],
        291 => ['clp' => 'SOLMQD', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis a subi un incident. Nous vous remercions de prendre contact avec notre service clients, au 3631 pour les clients Particuliers auprès de vos interlocuteurs habituels pour les clients Entreprises.'],
        292 => ['clp' => 'SOLVOL', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis a subi un incident. Nous vous remercions de prendre contact avec notre service clients, au 3631 pour les clients Particuliers auprès de vos interlocuteurs habituels pour les clients Entreprises.'],
        293 => ['clp' => 'TEMTEM', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        294 => ['clp' => 'TRAINT', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        295 => ['clp' => 'WCDAVA', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        296 => ['clp' => 'WCDENR', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Non affiché'],
        297 => ['clp' => 'AARRTG', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis a subi une erreur de tri, il a maintenant repris son acheminement.'],
        298 => ['clp' => 'ACKNAD', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera présenté le prochain jour ouvré et nécessite une remise en mains propres. Si vous êtes absent, vous pouvez nous donner vos instructions sur laposte.fr/modification-livraison'],
        299 => ['clp' => 'DOUFAC', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est en cours d\'acheminement et fera l\'objet d\'une facturation différée.'],
        300 => ['clp' => 'ECHCLI', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_TRANSIT, 'label' => 'Votre colis est pris en charge par La Poste. Il est en cours d\'acheminement.'],
        301 => ['clp' => 'LIVACC', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_DELIVERED, 'label' => 'Votre colis a été livré à l\'accueil.'],
        302 => ['clp' => 'LIVBAL', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_DELIVERED, 'label' => 'Votre colis a été livré dans la boite aux lettres du destinataire.'],
        303 => ['clp' => 'LIVCGA', 'is_anomaly' => false, 'change_order_status' => LpcOrderStatuses::WC_LPC_DELIVERED, 'label' => 'Votre colis a été livré sur votre ordre à une autre adresse'],
        304 => ['clp' => 'LIVRLI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est arrivé au point de retrait.'],
        305 => ['clp' => 'PCHREN', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis ne peut actuellement être livré à son destinataire, l\'adresse de livraison étant incomplète.'],
        306 => ['clp' => 'RCDABS', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être livré, il est retourné à l\'expéditeur.'],
        307 => ['clp' => 'RCDCPE', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur, la prestation de transport choisie n\'est pas admise pour le pays de destination.'],
        308 => ['clp' => 'RCDDES', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être livré, les informations du destinataire étant incomplètes. Il est retourné à l\'expéditeur.'],
        309 => ['clp' => 'RCDDOC', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis n\'a pas pu être livré, il est retourné à l\'expéditeur.'],
        310 => ['clp' => 'RCDPDS', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis est retourné à l\'expéditeur, son poids dépasse la limite autorisée dans le pays de destination.'],
        311 => ['clp' => 'RDVLDF', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'La date de livraison du colis a été confirmée.'],
        312 => ['clp' => 'REFINS', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis à destination internationale a subi un incident. Nous sommes en attente des instructions de livraison de la part du destinataire. '],
        313 => ['clp' => 'RENEMB', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis a été retourné à l\'expéditeur en raison d\'un embargo vers le pays de destination.'],
        314 => ['clp' => 'RSDCNI', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera livré au destinataire conformément à ses nouvelles instructions.'],
        315 => ['clp' => 'RSDCNS', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera mis à disposition dans la consigne choisie par le destinataire'],
        316 => ['clp' => 'RSDREL', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Votre colis sera mis à disposition au relais commerçant choisi par le destinataire.'],
        317 => ['clp' => 'RSTDIF', 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'La livraison de votre colis est programmée en seconde partie de journée.'],
        318 => ['clp' => 'SOLMQT', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Votre colis a subi un incident, veuillez contacter votre expéditeur.'],
        319 => ['clp' => 'DOUFCM', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Manque Document : facture commerciale'],
        320 => ['clp' => 'DOUFCI', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Manque Document : facture commerciale incomplète incorrecte'],
        321 => ['clp' => 'DOUCOM', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Manque Document : certificat (AIMG, CITES, EUR1,...)'],
        322 => ['clp' => 'DOURES', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Manque Document : licence'],
        323 => ['clp' => 'DOUDDM', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Manque Document : déclaration en douane CN23'],
        324 => ['clp' => 'DOUDDI', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Manque Document : déclaration en douane CN23 illisible incorrecte'],
        325 => ['clp' => 'DOUEOR', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Manque Information : n° EORI destinataire'],
        326 => ['clp' => 'DOUNIR', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Manque Information : n° de TVA de l’importateur'],
        327 => ['clp' => 'DOUEXI', 'is_anomaly' => true, 'change_order_status' => LpcOrderStatuses::WC_LPC_ANOMALY, 'label' => 'Manque Information : fournir tous les numéros de colis du groupage'],
        LpcOrderStatuses::WC_LPC_UNKNOWN_STATUS_INTERNAL_CODE => ['clp' => null, 'is_anomaly' => false, 'change_order_status' => null, 'label' => 'Code colissimo inconnu'],
    );
    // phpcs:enable

    protected $status_by_clp;

    public function getStatusInfo($intStatusCode) {
        return @$this->status_list[$intStatusCode];
    }

    public function getInternalCodeForClp($clp) {
        if (null === $this->status_by_clp) {
            $this->status_by_clp = [];
            foreach ($this->status_list as $id => $status) {
                $this->status_by_clp[$status['clp']] = $id;
            }
        }

        return $this->status_by_clp[$clp] ?? LpcOrderStatuses::WC_LPC_UNKNOWN_STATUS_INTERNAL_CODE;
    }

    public function getAnomalyInternalCodes() {
        return array_keys(
            array_filter(
                $this->status_list,
                function ($status) {
                    return $status['is_anomaly'];
                }
            )
        );
    }

    public function getToPrintInternalCodes() {
        return [
            $this->getInternalCodeForClp('COMCFM'),
        ];
    }

}
