<?php
use Mewz\Framework\Util\Number;

defined('ABSPATH') or die;

/**
 * @var Mewz\Framework\Services\View $this
 * @var Mewz\WCAS\Models\AttributeStock $stock
 */

$lang = str_replace('_', '-', get_bloginfo('language'));

$upgrade_hint = MEWZ_WCAS_LITE ? '</span> <span class="upgrade-hint">' . __('Only available in the full version', 'woocommerce-attribute-stock') . ' &mdash; <a href="' . esc_url($this->plugin->sale_url()) . '" target="_blank">' . __('Upgrade Now', 'woocommerce-attribute-stock') . '</a>' : '';

woocommerce_wp_text_input([
	'label' => __('Low stock threshold', 'woocommerce'),
	'id' => 'mewz_wcas_low_stock',
	'name' => 'mewz_wcas[low_stock]',
	'type' => 'number',
	'placeholder' => get_option('woocommerce_notify_low_stock_amount', '0'),
	'description' => __('When stock reaches this amount or less, you will be notified by email (if enabled).', 'woocommerce-attribute-stock') ,
	'desc_tip' => true,
	'value' => Number::period_decimal($stock->low_stock()),
	'custom_attributes' => ['step' => 'any', 'lang' => $lang],
]);

woocommerce_wp_checkbox([
	'label' => __('Limit product stock', 'woocommerce-attribute-stock'),
	'id' => 'mewz_wcas_limit_products',
	'name' => 'mewz_wcas[limit_products]',
	'description' => __('Restrict available stock for matching products and prevent over-purchasing', 'woocommerce-attribute-stock') . ' <a class="help-icon-link" href="' . esc_url($this->plugin->docs_url('advanced-usage.html#how-product-stock-limiting-works')) . '" target="_blank" title="' . esc_attr__('Learn more', 'woocommerce-attribute-stock') . '"></a>' . $upgrade_hint,
	'cbvalue' => 1,
	'value' => MEWZ_WCAS_LITE ? 0 : (int)$stock->limit_products(),
	'custom_attributes' => MEWZ_WCAS_LITE ? ['disabled' => 'disabled'] : [],
]);

woocommerce_wp_checkbox([
	'label' => __('Match all groups', 'woocommerce-attribute-stock'),
	'id' => 'mewz_wcas_match_all',
	'name' => 'mewz_wcas[match_all]',
	'description' => __('Reduce stock for multiple matching attribute groups at the same time', 'woocommerce-attribute-stock') . ' <a class="help-icon-link" href="' . esc_url($this->plugin->docs_url('advanced-usage.html#settings-tab')) . '" target="_blank" title="' . esc_attr__('Learn more', 'woocommerce-attribute-stock') . '"></a>',
	'cbvalue' => 1,
	'value' => (int)$stock->match_all(),
]);
