<?php
namespace Mewz\WCAS\Actions\Front;

use Mewz\Framework\Base\Action;
use Mewz\WCAS\Util\Cart;

class CartItems extends Action
{
	public $error_count = 0;

	public function __hooks()
	{
		add_filter('woocommerce_cart_contents_changed', [$this, 'cart_set_variation_data'], 5);
		add_filter('woocommerce_cart_contents_changed', [$this, 'cart_set_backorder_status'], 20);

		add_action('woocommerce_check_cart_items', [$this, 'check_cart_items_before'], 0);
		add_action('woocommerce_check_cart_items', [$this, 'check_cart_items_after'], 2);

		add_action('woocommerce_checkout_create_order_line_item', [$this, 'checkout_create_order_line_item'], 5, 4);
	}

	public function cart_set_variation_data($cart_contents)
	{
		Cart::$cache = [];

		foreach ($cart_contents as $item) {
			Cart::set_item_product_variation_data($item);
		}

		return $cart_contents;
	}

	public function cart_set_backorder_status($cart_contents)
	{
		if (!$cart_contents) {
			return $cart_contents;
		}

		foreach ($cart_contents as $item) {
			if (isset($item['data']) && $item['data'] instanceof \WC_Product && property_exists($item['data'], 'mewz_wcas_backordered')) {
				$item['data']->mewz_wcas_backordered = null;
				$item['data']->mewz_wcas_stock_status = null;
		    }
		}

		if (!$cart_limits = Cart::get_over_shared_attribute_stock()) {
			return $cart_contents;
		}

		foreach ($cart_limits as $cart_limit) {
			$backordered = $cart_limit['cart_qty'] - $cart_limit['stock_qty'];

			foreach ($cart_limit['cart_items'] as $item) {
				/** @var \WC_Product $product */
				$product = $item['data'];

				if (!property_exists($product, 'mewz_wcas_backordered') || $product->mewz_wcas_backordered === null) {
					$product->mewz_wcas_backordered = 0;
			    }

				$product->mewz_wcas_backordered += $backordered;
				$product->mewz_wcas_stock_status = 'onbackorder';
			}
		}

		return $cart_contents;
	}

	public function check_cart_items_before()
	{
		// don't check attribute stock if checking cart items has been disabled
		if (!has_action('woocommerce_check_cart_items', [WC()->cart, 'check_cart_items'])) {
			return;
		}

		// first check product stock without any attribute stock applied
		ProductLimits::$enabled = false;

		// save current error count so we can check if there are any product stock errors in the next step
		$this->error_count = wc_notice_count('error');
	}

	public function check_cart_items_after()
	{
		if (ProductLimits::$enabled || wc_notice_count('error') > $this->error_count) {
			return;
		}

		// re-enable attribute stock limits for the following stock checks
		ProductLimits::$enabled = true;

		// check stock of individual items, with attribute stock applied,
		// but without taking into account other items in the cart
		if (is_wp_error($result = Cart::check_individual_items_stock())) {
			wc_add_notice($result->get_error_message(), 'error');
			return;
		}

		// check that there is enough attribute stock between all items in the cart
		if (is_wp_error($result = Cart::check_shared_attribute_stock())) {
			wc_add_notice($result->get_error_message(), 'error');
			return;
		}
	}

	/**
	 * @param \WC_Order_Item_Product $order_item
	 * @param string $cart_item_key
	 * @param array $cart_item
	 * @param \WC_Order $order
	 *
	 * @return void
	 */
	public function checkout_create_order_line_item($order_item, $cart_item_key, $cart_item, $order)
	{
		if (!$cart_item || !isset($cart_item['data']) || !$cart_item['data'] instanceof \WC_Product) {
			return;
		}

		$product = $cart_item['data'];

		if (property_exists($product, 'mewz_wcas_backordered') && $product->mewz_wcas_backordered > 0 && $product->backorders_require_notification()) {
			$meta_key = apply_filters('woocommerce_backordered_item_meta_name', __('Backordered', 'woocommerce'), $order_item);

			if (!$order_item->meta_exists($meta_key)) {
				$order_item->add_meta_data($meta_key, sprintf(__('%d (Shared)', 'woocommerce-attribute-stock'), $product->mewz_wcas_backordered));
			}
		}
	}
}
