<?php
namespace Mewz\WCAS\Actions\Admin\Stock;

use Mewz\Framework\Base\Action;
use Mewz\WCAS\Models\AttributeStock;
use Mewz\WCAS\Util\Matches;

class StockSave extends Action
{
	public function __hooks()
	{
		add_filter('wp_insert_post_data', [$this, 'wp_insert_post_data'], 10, 4);
		add_action('save_post_mewz_attribute_stock', [$this, 'save_attribute_stock'], 10, 3);
		add_action('post_updated', [$this, 'post_updated'], 15, 3);
	}

	public function wp_insert_post_data($data, $postarr, $unsanitized_postarr = null, $update = true)
	{
		if (!$update || empty($_POST['post_ID']) || empty($postarr['ID']) || empty($postarr['post_type']) || $postarr['post_type'] !== 'mewz_attribute_stock' || empty($_POST['mewz_wcas']) || (int)$_POST['post_ID'] !== (int)$postarr['ID'] || (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)) {
			return $data;
		}

		$data['post_status'] = empty($_POST['mewz_wcas']['enabled']) ? 'draft' : 'publish';

	    return $data;
	}

	public function save_attribute_stock($post_id, $post, $update)
	{
		if (!$update || empty($_POST['post_ID']) || empty($_POST['mewz_wcas']) || (int)$_POST['post_ID'] !== $post->ID || (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) || $post->post_type === 'revision') {
			return;
		}

		$stock = new AttributeStock($post, 'edit');
		if (!$stock->exists()) return;

		$data = wp_unslash($_POST['mewz_wcas']);

		// reset slug to title
		if ($stock->slug() !== ($slug = sanitize_title($post->post_title))) {
			$data['slug'] = wp_unique_post_slug($slug, $post->ID, $post->post_status, $post->post_type, $post->post_parent);
		}

		// save checkboxes/switches
		$data['match_all'] = !empty($data['match_all']);

		// only save limit product stock option in full version
		if (!MEWZ_WCAS_LITE) {
			$data['limit_products'] = !empty($data['limit_products']);
		}

		// save empty multiselect lists
		empty($data['products']) && $data['products'] = [];
		empty($data['exclude_products']) && $data['exclude_products'] = [];
		empty($data['categories']) && $data['categories'] = [];
		empty($data['exclude_categories']) && $data['exclude_categories'] = [];
		empty($data['product_types']) && $data['product_types'] = [];

		$stock->bind($data);

		if (isset($_POST['mewz_wcas_attributes']) && empty($_POST['mewz_wcas_attributes_noupdate'])) {
			Matches::save_sets($stock->id(), $_POST['mewz_wcas_attributes']);
		}

		$stock->save(true);

		add_filter('redirect_post_location', [$this, 'redirect_post_location'], 10, 2);
	}

	public function redirect_post_location($location, $post_id)
	{
		if (!empty($_REQUEST['referredby']) && strpos($location, 'message=4') !== false && strpos($location, '&back=') === false) {
			$location = add_query_arg(['back' => urlencode(stripslashes($_REQUEST['referredby']))], $location);
		}

	    return $location;
	}

	public function post_updated($post_id, $post_after, $post_before)
	{
		if ($post_after->post_type === 'mewz_attribute_stock') {
			// remove '_wp_old_slug' meta as it's not needed for attribute stock posts
			delete_post_meta($post_id, '_wp_old_slug');
		}
	}
}
