<?php
namespace Mewz\WCAS\Actions\Admin\Settings;

use Mewz\Framework\Base\Action;

class InventorySettings extends Action
{
	public function __hooks()
	{
		add_filter('woocommerce_get_settings_products', [$this, 'woocommerce_get_settings_products'], 10, 2);
	}

	public function woocommerce_get_settings_products($settings, $section)
	{
		if ($section === 'inventory') {
			$settings[] = [
				'title' => __('Attribute Stock', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_options',
				'type' => 'title',
				'desc' => '',
			];

			$settings[] = [
				'title' => __('Limit product stock', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_limit_product_stock',
				'type' => 'select',
				'desc' => __("When set to 'Auto', product stock will only be limited on the frontend, in cron tasks, and during certain actions. Setting 'Everywhere' will limit product stock in admin views, and may improve compatibility with other plugins.", 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'class' => 'wc-enhanced-select',
				'options' => [
					'auto' => __('Auto', 'woocommerce-attribute-stock'),
					'yes' => __('Everywhere', 'woocommerce'),
					'no' => __('Disabled'),
				],
			];

			$settings[] = [
				'title' => __('Allow backorders?', 'woocommerce'),
				'id' => 'mewz_wcas_allow_backorders',
				'type' => 'select',
				'desc' => __('Allow backorders for products using attribute stock, when product stock management is disabled. Does not affect products with stock management enabled, or products that are not using attribute stock.', 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'class' => 'wc-enhanced-select',
				'options' => wc_get_product_backorder_options(),
			];

			$settings[] = [
				'title' => __('Out of stock variations', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_outofstock_variations',
				'type' => 'select',
				'desc' => __("Select how variation options will be displayed when out of stock. This only applies when the \"Hide out of stock items\" setting is disabled, and affects all variation options site-wide regardless of attribute stock.", 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'class' => 'wc-enhanced-select',
				'options' => [
					'outofstock' => __('Out of stock', 'woocommerce'),
					'greyedout' => __('Greyed out', 'woocommerce-attribute-stock'),
					'hidden' => __('Hidden', 'woocommerce'),
				],
			];

			$settings[] = [
				'title' => __('Unmatched "Any" variations', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_unmatched_any_variations',
				'type' => 'select',
				'desc' => __("Select how 'Any' variation options that don't match attribute stock will be displayed on the frontend. Only affects variations with 'Any' selected for some or all attribute terms.", 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'class' => 'wc-enhanced-select',
				'options' => [
					'no' => __('No change'),
					'outofstock' => __('Out of stock', 'woocommerce'),
					'greyedout' => __('Greyed out', 'woocommerce-attribute-stock'),
					'hidden' => __('Hidden', 'woocommerce'),
				],
			];

			$settings[] = [
				'title' => __('Sync product visibility', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_sync_product_visibility',
				'type' => 'select',
				'desc' => __("Update 'outofstock' visibility taxonomy for top-level products to reflect attribute stock status. This allows product queries to respect attribute stock, for example when using the \"Hide out of stock items\" setting. 'Auto' mirrors the \"Hide out of stock items\" setting.", 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'class' => 'wc-enhanced-select',
				'options' => [
					'auto' => __('Auto', 'woocommerce-attribute-stock'),
					'yes' => __('Enabled'),
					'no' => __('Disabled'),
				],
			];

			$settings[] = [
				'title' => __('Trigger product stock actions', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_trigger_product_stock_actions',
				'type' => 'select',
				'desc' => __('Trigger product stock change actions when attribute stock changes. Many plugins require these actions to know when stock changes on your site. However, in some cases this might cause issues with certain plugins, or simply not be needed and use unnecessary system resources.', 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'class' => 'wc-enhanced-select',
				'options' => [
					'yes' => __('Enabled'),
					'no' => __('Disabled'),
				],
			];

			$settings[] = [
				'title' => __('Ajax Variation Threshold', 'woocommerce-attribute-stock'),
				'id' => 'mewz_wcas_ajax_variation_threshold',
				'type' => 'number',
				'desc' => __('Allows changing the default WooCommerce Ajax Variation Threshold value. When products have more than this number of variations, WooCommerce will load them via Ajax. This is often problematic as it incurs extra loading times and prevents hiding or disabling out-of-stock options. Most servers running WooCommerce can handle a value of at least 300.', 'woocommerce-attribute-stock'),
				'desc_tip' => true,
				'placeholder' => '30',
				'css' => 'width: 120px;',
				'custom_attributes' => [
					'step' => '1',
					'min' => '0',
				],
			];

			$settings[] = [
				'id' => 'mewz_wcas_options',
				'type' => 'sectionend',
			];
		}

		return $settings;
	}
}
