<?php
namespace Mewz\WCAS\Actions\Admin\Products;

use Mewz\Framework\Base\Action;
use Mewz\Framework\Util\Number;

class ProductVariationOptions extends Action
{
	public function __hooks()
	{
		add_action('woocommerce_variation_header', [$this, 'variation_header'], 5, 2);
		add_action('woocommerce_variation_options', [$this, 'variation_options'], -10, 3);
		add_action('woocommerce_product_after_variable_attributes', [$this, 'after_variable_attributes'], -10, 3);
		add_action('woocommerce_admin_process_variation_object', [$this, 'admin_process_variation_object'], 10, 2);
	}

	public function variation_header($post, $index)
	{
		if (!$post || empty($post->ID)) return;

		$multiplier = get_post_meta($post->ID, '_mewz_wcas_multiplier', true);

		if ($multiplier !== '') {
			echo '<span class="mewz_wcas_variation_multiplier">&times;' . Number::local_format((float)$multiplier) . '</span>';
		}
	}

	public function variation_options($index, $data, $post)
	{
		if (!$post || empty($post->ID)) return;

		$this->view->render('admin/products/variation-options', [
			'post' => $post,
			'index' => $index,
		]);
	}

	public function after_variable_attributes($index, $data, $post)
	{
		if (!$post || empty($post->ID)) return;

		$this->view->render('admin/products/variation-fields', [
			'post' => $post,
			'index' => $index,
		]);
	}

	public function admin_process_variation_object($variation, $i)
	{
		if (!empty($_POST['variable_mewz_wcas_exclude'][$i])) {
			$variation->update_meta_data('_mewz_wcas_exclude', 1);
		} else {
			$variation->delete_meta_data('_mewz_wcas_exclude');
		}

		if (isset($_POST['variable_mewz_wcas_multiplier'][$i]) && $_POST['variable_mewz_wcas_multiplier'][$i] !== '') {
			$value = max(0, (float)$_POST['variable_mewz_wcas_multiplier'][$i]);
			$variation->update_meta_data('_mewz_wcas_multiplier', Number::period_decimal($value));
		} else {
			$variation->delete_meta_data('_mewz_wcas_multiplier');
		}
	}
}
