/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
(function () {
  if (!window.jQuery) return;
  window.mewz_wcas_expand_product_variations = expandProductVariations;
  if (window.mewz_wcas_variable_data) {
    expandProductVariations(window.mewz_wcas_variable_data);

    // Porto theme compatibility
    jQuery(document.body).on('porto_init', (e, wrap) => {
      if (!wrap || !wrap[0] || wrap[0] === document.body || !wrap[0].classList.contains('product')) {
        return;
      }
      let product = wrap[0].querySelector('.variations_form');
      if (product && product.dataset.product_id && product.dataset.product_variations) {
        expandProductVariations(window.mewz_wcas_variable_data, [product]);
      }
    });
  }
  function expandProductVariations(_ref, products) {
    let {
      data: productData,
      settings
    } = _ref;
    if (products === undefined) {
      products = document.querySelectorAll('[data-product_id][data-product_variations]');
    } else if (!products) {
      return false;
    }
    let expanded = false;
    for (let i = 0; i < products.length; i++) {
      const product = products[i];
      if (!product || !product.dataset || product.dataset.mewzWcasExpanded) {
        continue;
      }
      const productId = product.dataset.product_id;
      if (productId > 0 && productId in productData) {
        const variations = jQuery(product).data('product_variations');
        if (variations) {
          expandVariations(variations, productData[productId], settings);
        }
      }
      product.dataset.mewzWcasExpanded = '1';
      expanded = true;
    }
    return expanded;
  }
  function expandVariations(variations, _ref2, settings) {
    let {
      vd: variationsData,
      va: variableAttributes,
      pa: productAttributes,
      md: matchData,
      sh: stockHtml
    } = _ref2;
    let variationIndex = variations.length;
    while (--variationIndex >= 0) {
      const variation = variations[variationIndex];
      if (!(variation.variation_id in variationsData)) {
        continue;
      }
      const catchall = !settings.hide_out_of_stock && settings.outofstock_variations === 'outofstock';
      const attributes = getVariationAttributes(variation, variableAttributes, catchall);
      const combinations = getAttributeCombinations(attributes);
      const expandedVariations = [];
      for (let i = 0; i < combinations.length; i++) {
        const expanded = expandVariation(variation, combinations[i], productAttributes, matchData, variationsData[variation.variation_id], stockHtml, settings);
        if (expanded) {
          expandedVariations.push(expanded);
        }
      }
      if (expandedVariations.length || settings.unmatched_any_variations === 'hidden') {
        Array.prototype.splice.apply(variations, [variationIndex, 1].concat(expandedVariations));
      }
    }
  }
  function expandVariation(variation, combination, productAttributes, matchData, variationData, stockHtml, settings) {
    const attributes = appendAttributes(combination, productAttributes);
    let limit = matchLimit(attributes, matchData, variationData);
    const data = {
      attributes: {}
    };
    const backorders_allowed = variationData.b ? variationData.b !== 'no' : variation.backorders_allowed;
    if (backorders_allowed !== variation.backorders_allowed) {
      data.backorders_allowed = backorders_allowed;
    }
    if (limit !== null) {
      // limit available stock by attribute stock if backorders not allowed
      if (!backorders_allowed && (variation.max_qty === '' || limit < variation.max_qty)) {
        if (limit <= settings.no_stock_amount) {
          data.max_qty = '';
          data.is_in_stock = false;
        } else {
          data.max_qty = limit;
        }
      }
    } else if (settings.unmatched_any_variations && settings.unmatched_any_variations !== 'no') {
      if (settings.unmatched_any_variations === 'hidden') {
        return false;
      } else if (settings.unmatched_any_variations === 'outofstock') {
        data.max_qty = '';
        data.is_in_stock = false;
        limit = 0;
      } else {
        data.variation_is_active = false;
      }
    }
    const is_in_stock = 'is_in_stock' in data ? data.is_in_stock : variation.is_in_stock;

    // display out of stock variations according to settings
    if (is_in_stock === false && !backorders_allowed) {
      if (settings.hide_out_of_stock || settings.outofstock_variations === 'hidden') {
        return false;
      } else if (settings.outofstock_variations === 'greyedout') {
        data.variation_is_active = false;
      }
    }

    // add combination as attributes
    for (const attr in combination) {
      data.attributes['attribute_' + attr] = combination[attr];
    }

    // update stock text for stock value limited by attribute stock
    if (limit !== null && stockHtml && 'b' in variationData && (!('q' in variationData) || limit < variationData.q)) {
      data.availability_html = getStockHtml(stockHtml, limit, variationData.b, settings.low_stock_amount);
    }
    return objectAssign({}, variation, data);
  }
  function getVariationAttributes(variation, variableAttributes, catchAll) {
    const attributes = {};
    for (const attr in variation.attributes) {
      const term = variation.attributes[attr];
      const taxonomy = attr.slice(10);
      if (term === '' && taxonomy in variableAttributes) {
        attributes[taxonomy] = variableAttributes[taxonomy];
        if (catchAll && attributes[taxonomy].indexOf('') === -1) {
          attributes[taxonomy].push('');
        }
      } else {
        attributes[taxonomy] = [term];
      }
    }
    return attributes;
  }
  function appendAttributes(attributes, append) {
    attributes = objectCopy(attributes);
    for (const attr in append) {
      const terms = append[attr];
      if (terms.length === 1) {
        attributes[attr] = terms[0];
      } else {
        attributes[attr] = terms;
      }
    }
    return attributes;
  }
  function matchLimit(attributes, matchData, variationData) {
    let limit = null;
    const vx = variationData && typeof variationData.x === 'number' ? variationData.x : null;
    for (let i = 0; i < matchData.length; i++) {
      const {
        s: sets,
        q: quantity,
        ma: matchAll
      } = matchData[i];
      let multiplier = null;
      for (let j = 0; j < sets.length; j++) {
        const set = sets[j];
        if (!matchRows(attributes, set.r)) {
          continue;
        }
        const x = vx === null ? set.x == null ? 1 : set.x : vx;
        if (multiplier === null) {
          multiplier = x;
        } else {
          multiplier += x;
        }
        if (!matchAll) break;
      }
      if (multiplier !== null) {
        const matchLimit = multiplier > 0 ? Math.floor(quantity / multiplier) : 0;
        if (limit === null || matchLimit < limit) {
          limit = matchLimit;
        }
      }
    }
    return limit;
  }
  function matchRows(attributes, rows) {
    for (let attr in rows) {
      const term = rows[attr];
      attr = 'pa_' + attr;
      const hasMatch = attr in attributes && (term === '' || term === attributes[attr] || Array.isArray(attributes[attr]) && attributes[attr].indexOf(term) !== -1);

      // if any rows *don't* match the selected attributes, then no match
      if (!hasMatch) return false;
    }
    return true;
  }
  function getStockHtml(stockHtml, quantity, backorders, lowStockAmount) {
    let html;
    if (quantity <= 0) {
      html = stockHtml.out[backorders];
    } else if (quantity <= lowStockAmount) {
      html = stockHtml.low[backorders];
    } else {
      html = stockHtml.in[backorders];
    }
    return html.replace('%d', quantity);
  }
  function getAttributeCombinations(attributes) {
    let result = [{}];
    for (const key in attributes) {
      const terms = attributes[key];
      const append = [];
      for (let i = 0; i < result.length; i++) {
        let product = result[i];
        for (let j = 0; j < terms.length; j++) {
          product = objectCopy(product);
          product[key] = terms[j];
          append.push(product);
        }
      }
      result = append;
    }
    return result;
  }
  function objectAssign(object) {
    for (let i = 1; i < arguments.length; i++) {
      const obj = arguments[i];
      for (const key in obj) {
        object[key] = obj[key];
      }
    }
    return object;
  }
  function objectCopy(object) {
    const copy = {};
    for (const key in object) {
      copy[key] = object[key];
    }
    return copy;
  }
})();
/******/ })()
;