/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other entry modules.
(() => {

;// CONCATENATED MODULE: ./admin/stock-list/modules/header-actions.js
const $ = jQuery;
const headerActions = window.mewz_wcas_header_actions || {};
let $importFileInput;
function load() {
  const $actions = $(headerActions.html);
  $actions.insertAfter('.wrap > .page-title-action');
  $('#mewz-wcas-import-button').on('click', handleImportAction);
}
function handleImportAction() {
  const $button = $(this);
  if (!$importFileInput) {
    const $form = $(`<form action="${$button.data('action')}" method="post" enctype="multipart/form-data" style="display: none;"></form>`);
    $importFileInput = $('<input type="file" name="import_file" />');
    $importFileInput.on('change', () => $form.submit());
    $('body').append($form.append($importFileInput));
  }
  $importFileInput[0].click();
}
;// CONCATENATED MODULE: ./admin/stock-list/modules/filter-attribute.js
const filter_attribute_$ = jQuery;
const attrData = window.mewz_wcas_attribute_options || {};
let $attrFilter, $termFilter;
function filter_attribute_load() {
  $attrFilter = filter_attribute_$('#filter_attribute');
  $termFilter = filter_attribute_$('#filter_term');
  $attrFilter.on('change', populateTermOptions);

  // prevent prefilled values due to browser bfcache
  $attrFilter.closest('form')[0].reset();
}
function populateTermOptions() {
  const attrId = +$attrFilter.val();
  const options = getTermOptions(attrId);
  $termFilter.find('option:not([value=""])').remove();
  $termFilter.append(options);
  $termFilter.val('');
  $termFilter.prop('hidden', !options.length);
}
function getTermOptions(attributeId) {
  if (!attrData[attributeId]) {
    return [];
  }
  let options = [];
  const terms = attrData[attributeId].terms;
  for (let i = 0; i < terms.length; i++) {
    options.push(filter_attribute_$('<option/>', {
      value: terms[i][0],
      text: terms[i][1]
    }));
  }
  return options;
}
;// CONCATENATED MODULE: ./admin/stock-list/modules/inline-edit.js
const inline_edit_$ = jQuery;
const {
  rest_url,
  rest_nonce,
  locale
} = window.mewz_wcas_stock_list_data;
const placeholder = 0 .toLocaleString(locale, {
  minimumFractionDigits: 2
});
let $table;
function inline_edit_load() {
  $table = inline_edit_$('#the-list');
  $table.on('click', '.inline-edit-quantity .action-button', inlineEditQuantity);
}
function inlineEditQuantity(e) {
  const $button = inline_edit_$(this);
  const $edit = $button.parent();
  const $td = $edit.closest('td');
  const action = $button.data('action');
  const currentQty = +$edit.data('quantity');
  const value = action === 'adjust' ? '' : currentQty;
  const $input = makeInput('number', value, placeholder);
  const $inputIcon = inline_edit_$('<span class="icon"></span>');
  const $inputWrap = inline_edit_$(`<span class="inline-edit-input-wrap ${action}"></span>`);
  $td.append($inputWrap.append($input, $inputIcon));
  $input.select();
  $td.addClass('inline-editing');
  $input.on('blur', stopEditing);
  $input.on('keydown', function (e) {
    if (e.key === 'Escape') {
      stopEditing();
    } else if (e.key === 'Enter') {
      e.preventDefault();
      handleUpdateStock();
    } else if (e.key === 'Tab') {
      handleUpdateStock();
      const $tr = $td.parent('tr');
      const buttonSelector = `.${action}-quantity-button`;
      const $nextButton = getNextButton($tr, buttonSelector, e.shiftKey);
      if ($nextButton) {
        e.preventDefault();
        $nextButton.click();
      }
    }
  });
  let $stockQuantity, origStockQtyHtml;
  function handleUpdateStock() {
    const newQty = +$input.val();
    stopEditing();
    if (action === 'adjust' ? !newQty : newQty === currentQty) {
      return;
    }
    $stockQuantity = $td.find('.stock-quantity');
    if (action === 'edit') {
      origStockQtyHtml = $stockQuantity.html();
      $stockQuantity.text(newQty.toLocaleString(locale, {
        maximumSignificantDigits: 20,
        maximumFractionDigits: 20
      }));
    }
    $td.addClass('inline-edit-pending');
    $td.find('.action-button').prop('disabled', true);
    const data = action === 'adjust' ? {
      adjust_quantity: newQty
    } : {
      quantity: newQty
    };
    ajaxUpdateStock($edit.data('stock-id'), data).done(onSuccess).error(onError).always(onComplete);
  }
  function stopEditing() {
    $inputWrap.remove();
    $td.removeClass('inline-editing');
  }
  function onSuccess(updated) {
    if (!updated || !('quantity' in updated) || !('formatted_quantity' in updated)) {
      return onError();
    }
    $td.find('.stock-quantity').replaceWith(updated.formatted_quantity);
    $edit.data('quantity', updated.quantity);
    $td.trigger('mewz_wcas_inline_stock_quantity_updated', [updated]);
  }
  function onError() {
    if (action === 'edit') {
      $stockQuantity.html(origStockQtyHtml);
    }
  }
  function onComplete() {
    $td.removeClass('inline-edit-pending');
    $td.find('.action-button').prop('disabled', false);
  }
}
function makeInput(type, value, placeholder) {
  return inline_edit_$('<input/>', {
    type,
    value,
    class: 'inline-edit-input inline-edit-input-quantity',
    step: 'any',
    lang: locale,
    placeholder
  });
}
function ajaxUpdateStock(stockId, data) {
  return inline_edit_$.ajax({
    url: rest_url + '/stock/' + stockId + '?_locale=user',
    method: 'POST',
    dataType: 'json',
    data,
    beforeSend(xhr) {
      xhr.setRequestHeader('X-WP-Nonce', rest_nonce);
    }
  });
}
function getNextButton($tr, buttonSelector) {
  let prev = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  let $nextRow = getNextRow($tr, prev);
  if ($nextRow.is($tr)) return false;
  let $nextButton = $nextRow.find(buttonSelector);
  if (!$nextButton.length) return false;
  while ($nextButton.prop('disabled')) {
    $nextRow = getNextRow($nextRow, prev);
    if ($nextRow.is($tr)) return false;
    $nextButton = $nextRow.find(buttonSelector);
    if (!$nextButton.length) return false;
  }
  return $nextButton;
}
function getNextRow($tr) {
  let prev = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  let $nextRow = prev ? $tr.prev('tr') : $tr.next('tr');
  if (!$nextRow.length) {
    $nextRow = prev ? $tr.siblings('tr:last-of-type') : $tr.siblings('tr:first-of-type');
  }
  return $nextRow;
}
;// CONCATENATED MODULE: ./admin/stock-list/modules/confirmations.js
const confirmations_$ = jQuery;
const {
  __,
  sprintf
} = mewz.i18n;
function confirmations_load() {
  const $tableList = confirmations_$('#the-list');
  if ($tableList.length) {
    $tableList.on('click', 'tr.status-publish .action-trash', onTableListClick);
  }
}
function onTableListClick(e) {
  const title = confirmations_$(this).closest('tr').find('td.column-title .row-title').text();
  const message = sprintf(__('Are you sure you want to delete %s?'), `"${title}"`);
  if (!confirm(message)) {
    e.preventDefault();
  }
}
;// CONCATENATED MODULE: ./admin/stock-list/index.js




jQuery(() => {
  load();
  filter_attribute_load();
  inline_edit_load();
  confirmations_load();
});
})();

// This entry need to be wrapped in an IIFE because it need to be isolated against other entry modules.
(() => {
// extracted by mini-css-extract-plugin

})();

/******/ })()
;