<?php
/**
 * Block Information & Attributes File.
 *
 * @since 2.2.0
 *
 * @package uagb
 */

$btn_border_attributes = UAGB_Block_Helper::uag_generate_border_attribute(
	'btn',
	array(
		'borderTopLeftRadius'     => 3,
		'borderTopRightRadius'    => 3,
		'borderBottomLeftRadius'  => 3,
		'borderBottomRightRadius' => 3,
	)
);

$content_border_attributes = UAGB_Block_Helper::uag_generate_border_attribute(
	'content',
	array(
		'borderTopLeftRadius'     => 3,
		'borderTopRightRadius'    => 3,
		'borderBottomLeftRadius'  => 3,
		'borderBottomRightRadius' => 3,
	)
);

return array_merge(
	array(
		'modalTrigger'                => 'button',
		'buttonIconSpace'             => '5',
		'buttonIconSpaceTablet'       => '',
		'buttonIconSpaceMobile'       => '',
		'buttonIconSpaceType'         => 'px',
		'buttonIconPosition'          => 'after',
		'modalAlign'                  => 'left',
		'modalAlignTablet'            => '',
		'modalAlignMobile'            => '',
		'modalWidth'                  => 600,
		'modalWidthTablet'            => 600,
		'modalWidthMobile'            => 340,
		'modalWidthType'              => 'px',
		'modalHeight'                 => 350,
		'modalHeightTablet'           => 350,
		'modalHeightMobile'           => 300,
		'modalHeightType'             => 'px',
		'closeIconSize'               => 25,
		'closeIconPosition'           => 'popup-top-right',
		'overlayColor'                => 'rgba(0,0,0,0.75)',
		'closeIconColor'              => '',
		'paddingModalUnit'            => 'px',
		'mobilePaddingModalUnit'      => 'px',
		'tabletPaddingModalUnit'      => 'px',
		'paddingModalTop'             => '',
		'paddingModalBottom'          => '',
		'paddingModalLeft'            => '',
		'paddingModalRight'           => '',
		'paddingModalTopTablet'       => '',
		'paddingModalRightTablet'     => '',
		'paddingModalBottomTablet'    => '',
		'paddingModalLeftTablet'      => '',
		'paddingModalTopMobile'       => '',
		'paddingModalRightMobile'     => '',
		'paddingModalBottomMobile'    => '',
		'paddingModalLeftMobile'      => '',

		'iconSize'                    => 30,
		'iconColor'                   => '',
		'textColor'                   => '',

		'textFontFamily'              => '',
		'textLoadGoogleFonts'         => false,
		'textFontWeight'              => '',
		'textFontStyle'               => '',
		'textFontSize'                => '',
		'textFontSizeType'            => 'px',
		'textFontSizeTablet'          => '',
		'textFontSizeMobile'          => '',
		'textSpaceType'               => 'px',
		'textLineHeight'              => '',
		'textLineHeightType'          => 'em',
		'textLineHeightTablet'        => '',
		'textLineHeightMobile'        => '',
		'textLetterSpacing'           => '',
		'textLetterSpacingTablet'     => '',
		'textLetterSpacingMobile'     => '',
		'textLetterSpacingType'       => 'px',
		'textTransform'               => '',
		'textDecoration'              => '',

		'imageSize'                   => 'thumbnail',
		'imageWidthType'              => true,
		'imageWidth'                  => '',
		'imageWidthMobile'            => '',
		'imageWidthTablet'            => '',
		'imageWidthUnit'              => 'px',
		'imageWidthUnitTablet'        => 'px',
		'imageWidthUnitMobile'        => 'px',
		'iconimgBorderRadius'         => '0',
		'iconimgBorderRadiusUnit'     => 'px',

		'paddingBtnUnit'              => 'px',
		'mobilePaddingBtnUnit'        => 'px',
		'tabletPaddingBtnUnit'        => 'px',
		'paddingBtnTop'               => 14,
		'paddingBtnBottom'            => 14,
		'paddingBtnLeft'              => 32,
		'paddingBtnRight'             => 32,
		'paddingBtnTopTablet'         => '',
		'paddingBtnRightTablet'       => '',
		'paddingBtnBottomTablet'      => '',
		'paddingBtnLeftTablet'        => '',
		'paddingBtnTopMobile'         => '',
		'paddingBtnRightMobile'       => '',
		'paddingBtnBottomMobile'      => '',
		'paddingBtnLeftMobile'        => '',

		'btnFontFamily'               => '',
		'btnLoadGoogleFonts'          => false,
		'btnFontWeight'               => '',
		'btnFontStyle'                => '',
		'btnFontSize'                 => '',
		'btnFontSizeType'             => 'px',
		'btnFontSizeTablet'           => '',
		'btnFontSizeMobile'           => '',
		'btnSpaceType'                => 'px',
		'btnLineHeight'               => '',
		'btnLineHeightType'           => 'em',
		'btnLineHeightTablet'         => '',
		'btnLineHeightMobile'         => '',
		'btnLetterSpacing'            => '',
		'btnLetterSpacingTablet'      => '',
		'btnLetterSpacingMobile'      => '',
		'btnLetterSpacingType'        => 'px',
		'btnTransform'                => '',
		'btnDecoration'               => '',
		'btnLinkColor'                => '',
		'btnBgColor'                  => '',
		'btnLinkHoverColor'           => '',
		'btnBgHoverColor'             => '',
		'modalBoxHeight'              => 'auto',
		'maxHeight'                   => '90',
		'maxHeightTablet'             => '',
		'maxHeightMobile'             => '',
		'maxHeightType'               => 'vh',
		'backgroundType'              => 'none',
		'backgroundImageDesktop'      => '',
		'backgroundImageTablet'       => '',
		'backgroundImageMobile'       => '',
		'backgroundPositionDesktop'   => array(
			'x' => 0.5,
			'y' => 0.5,
		),
		'backgroundPositionTablet'    => '',
		'backgroundPositionMobile'    => '',
		'backgroundSizeDesktop'       => 'cover',
		'backgroundSizeTablet'        => '',
		'backgroundSizeMobile'        => '',
		'backgroundRepeatDesktop'     => 'no-repeat',
		'backgroundRepeatTablet'      => '',
		'backgroundRepeatMobile'      => '',
		'backgroundAttachmentDesktop' => 'scroll',
		'backgroundAttachmentTablet'  => '',
		'backgroundAttachmentMobile'  => '',
		'backgroundColor'             => '',
		'backgroundOpacity'           => '',
		'backgroundImageColor'        => '#FFFFFF75',
		'gradientValue'               => 'linear-gradient(90deg, rgba(6, 147, 227, 0.5) 0%, rgba(155, 81, 224, 0.5) 100%)',
		'backgroundCustomSizeDesktop' => 100,
		'backgroundCustomSizeTablet'  => '',
		'backgroundCustomSizeMobile'  => '',
		'backgroundCustomSizeType'    => '%',
		'overlayType'                 => 'none',
		'customPosition'              => 'default',
		'xPositionDesktop'            => '',
		'xPositionTablet'             => '',
		'xPositionMobile'             => '',
		'xPositionType'               => 'px',
		'xPositionTypeTablet'         => 'px',
		'xPositionTypeMobile'         => 'px',
		'yPositionDesktop'            => '',
		'yPositionTablet'             => '',
		'yPositionMobile'             => '',
		'yPositionType'               => 'px',
		'yPositionTypeTablet'         => 'px',
		'yPositionTypeMobile'         => 'px',
	),
	$btn_border_attributes,
	array(
		'btnBorderTopLeftRadius'     => 3,
		'btnBorderTopRightRadius'    => 3,
		'btnBorderBottomLeftRadius'  => 3,
		'btnBorderBottomRightRadius' => 3,
	),
	$content_border_attributes,
	array(
		'contentBorderTopLeftRadius'     => 3,
		'contentBorderTopRightRadius'    => 3,
		'contentBorderBottomLeftRadius'  => 3,
		'contentBorderBottomRightRadius' => 3,
	)
);
