<?php
namespace Mewz\WCAS\Actions\Workers;

use Mewz\Framework\Base\Action;
use Mewz\Framework\Util\WooCommerce;
use Mewz\WCAS\Util;

class OutOfStock extends Action
{
	public $update = false;

	public function __hooks()
	{
		add_action('woocommerce_update_options_products_inventory', [$this, 'clear_stock_item_cache']);

		if (apply_filters('mewz_wcas_track_oos_products', WooCommerce::hide_out_of_stock())) {
			add_action('mewz_wcas_stock_change', [$this, 'clear_stock_item_cache']);
			add_action('woocommerce_delete_product_transients', [$this, 'clear_product_cache']);

			add_action('shutdown', [$this, 'shutdown']);
			add_action('mewz_wcas_task_update_out_of_stock_cache', [$this, 'task_update_out_of_stock_cache']);
		}
	}

	public function clear_stock_item_cache()
	{
		$this->cache->delete_transient('oos_stock_items');

		$this->clear_product_cache();
	}

	public function clear_product_cache()
	{
		$this->cache->delete_transient('oos_products');

	    $this->update = true;
	}

	public function shutdown()
	{
		if ($this->update && apply_filters('mewz_wcas_track_oos_products', WooCommerce::hide_out_of_stock())) {
			$this->tasks->add('update_out_of_stock_cache');
		}
	}

	public function task_update_out_of_stock_cache()
	{
		if (!Util\Limits::product_limits_active()) {
			return $this->tasks->kill(501);
		}

		Util\Matches::get_oos_products();
	}
}
