<?php
namespace Mewz\Framework\Plugin;

use Mewz\Framework\Base\ServiceProxy;
use Mewz\Framework\Compatibility;

class Loader extends ServiceProxy
{
	public function register_tables() {}

	public function load()
	{
		load_plugin_textdomain('mewz-framework', false, $this->plugin->dirname . '/vendor/mewz/framework/languages');
		load_plugin_textdomain($this->plugin->domain, false, $this->plugin->dirname . '/languages');

		if ($this->plugin->db_version && version_compare($this->plugin->version, $this->plugin->db_version, '>')) {
			$this->plugin->installer->update();
		}

		if (!$this->plugin->__is_lite() && !class_exists(Updater::class, false)) {
			$this->plugin->__load_updater();

			if (!class_exists(Updater::class, false)) {
				require_once ABSPATH . 'wp-admin/includes/plugin.php';
				deactivate_plugins($this->plugin->basename);
			}
		}

		add_action('init', [$this, 'init'], 0);
		add_action('admin_init', [$this, 'admin_init']);
	}

	public function init()
	{
		if ($this->context->admin) {
			add_action('admin_enqueue_scripts', [$this, '__register_scripts'], 0);
		} else {
			add_action('wp_enqueue_scripts', [$this, '__register_scripts'], 0);
		}
	}

	public function admin_init()
	{
		if (!WP_DEBUG && !$this->plugin->__is_lite() && !class_exists(Authorizer::class, false)) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
			deactivate_plugins($this->plugin->basename, true);
		}
	}

	public function __register_scripts()
	{
		$this->register_fw_scripts();
		$this->register_scripts();

		if ($this->context->admin) {
			add_action('admin_enqueue_scripts', [$this->scripts, 'process_queue']);
		} else {
			add_action('wp_enqueue_scripts', [$this->scripts, 'process_queue']);
		}
	}

	public function register_fw_scripts()
	{
		$dist_url = $this->plugin->base_url . 'vendor/mewz/framework/assets/dist/';
		$i18n_deps = Compatibility\I18n::native_js_i18n() ? 'wp-i18n' : [];

		$this->scripts->register_js('mewz-i18n', $dist_url . 'mewz-i18n.min.js', ['deps' => $i18n_deps, 'ver' => $this->plugin->fw_version]);
	}

	public function register_scripts() {}

	/**
	 * Loads/runs an action controller.
	 *
	 * @see \Mewz\Framework\Base\Action
	 *
	 * @param string $class The action controller class
	 */
	public function action($class)
	{
		// allow the action controller to be swapped out for a different class or to not be loaded at all
		$class = apply_filters($this->plugin->prefix . '_override_action_class', $class, $this);

		if ($class) {
			/** @var \Mewz\Framework\Base\Action $class */
			$class::run($this->plugin);
		}
	}
}
