<?php
namespace Mewz\Framework\Util;

class Date
{
	public static function format($format = 'full', $time = null, $add_offset = false, $sep = null)
	{
		if ($time === null) {
			$time = time();
		} elseif (is_string($time) && $time !== (string)(int)$time) {
			$time = strtotime($time);
		}

		if ($add_offset) {
			$time += get_option('gmt_offset') * HOUR_IN_SECONDS;
		}

		switch ($format) {
			case 'full':
				if ($sep === null) $sep = ' ';
				$format = get_option('date_format') . $sep . get_option('time_format');
				break;

			case 'date':
				$format = get_option('date_format');
				break;

			case 'time':
				$format = get_option('time_format');
				break;

			case 'admin-full':
				$format = __('M j, Y @ H:i');
				break;

			case 'admin-short':
				$format = __('Y/m/d g:i:s a');
				break;

			case 'admin-date':
				$format = __('Y/m/d');
				break;
		}

		$format = apply_filters('mewz_date_format', $format, $time, $sep);

		return date_i18n($format, $time);
	}
}
