<?php
namespace Mewz\Framework\Base;

use Mewz\Framework\Plugin;

abstract class Action extends ServiceProxy
{
	/** @var static[] */
	protected static $instance = [];

	/**
	 * @param Plugin $plugin
	 *
	 * @return static
	 */
	public static function run(Plugin $plugin)
	{
		if (isset(self::$instance[static::class])) {
			return self::$instance[static::class];
		}

		$action = self::$instance[static::class] = new static($plugin);

		if ($action->__run() !== false) {
			$action->__hooks();
			$action->__scripts();
		}

		return $action;
	}

	/**
	 * @return static|null
	 */
	public static function instance()
	{
		return isset(self::$instance[static::class]) ? self::$instance[static::class] : null;
	}

	public function __run() {}

	public function __hooks() {}

	public function __scripts() {}
}
