<?php
namespace Mewz\WCAS\Actions\Common;

use Mewz\Framework\Base\Action;
use Mewz\WCAS\Util\Orders;

class UpdateOrderStock extends Action
{
	public function __hooks()
	{
		add_filter('woocommerce_hidden_order_itemmeta', [$this, 'hidden_order_itemmeta']);

		add_action('woocommerce_before_order_item_object_save', [$this, 'before_order_item_object_save'], 10, 2);
	    add_action('woocommerce_reduce_order_stock', [$this, 'reduce_order_stock']);
	    add_action('woocommerce_restore_order_stock', [$this, 'restore_order_stock']);
	    add_action('woocommerce_before_delete_order_item', [$this, 'before_delete_order_item']);
	    add_action('woocommerce_before_save_order_items', [$this, 'before_save_order_items'], 10, 2);
	    add_action('woocommerce_refund_created', [$this, 'refund_created'], 10, 2);
	}

	public function hidden_order_itemmeta($meta_keys)
	{
		$meta_keys[] = Orders::REDUCED_STOCK_META;

		return $meta_keys;
	}

	public function before_order_item_object_save(\WC_Order_Item $item, $data_store)
	{
		// ensure new order items are always created without reduced stock meta (e.g. when duplicating orders)
		if (!$item->get_id() && $item->get_type() === 'line_item') {
			$data = $item->get_data();

			if (empty($data['order_id'])) {
				$item->delete_meta_data(Orders::REDUCED_STOCK_META);
			}
		}
	}

	public function reduce_order_stock($order)
	{
		Orders::update_order_attribute_stock($order, 'reduce');
	}

	public function restore_order_stock($order)
	{
		Orders::update_order_attribute_stock($order, 'restore');
	}

	public function before_delete_order_item($item_id)
	{
		Orders::update_order_items_attribute_stock($item_id, 'restore');
	}

	public function before_save_order_items($order_id, $item_data)
	{
		if (empty($item_data['order_item_id']) || !$order_status = get_post_status($order_id)) {
			return;
		}

		$order_status = substr($order_status, 3);
		$has_valid_status = in_array($order_status, ['processing', 'completed', 'on-hold']);

		$order_items = [];

		foreach ($item_data['order_item_id'] as $item_id) {
			/** @var \WC_Order_Item_Product $item */
			$item = \WC_Order_Factory::get_order_item((int)$item_id);

			if (!$item || $item->get_type() !== 'line_item') {
				continue;
			}

			if ($has_valid_status || $item->meta_exists(Orders::REDUCED_STOCK_META)) {
				$item->set_quantity((float)$item_data['order_item_qty'][$item_id]);
				$order_items[] = $item;
			}
		}

		if ($order_items) {
			Orders::update_order_items_attribute_stock($order_items, 'sync', $order_id);
		}
	}

	public function refund_created($refund_id, $args)
	{
	    if (!$refund_id || empty($args['restock_items']) || empty($args['line_items']) || !$order = wc_get_order($args['order_id'])) {
		    return;
	    }

	    $refunded_items = $args['line_items'];
		$order_items = [];

	    /** @var \WC_Order_Item_Product $item */
		foreach ($order->get_items() as $item_id => $item) {
			if (!isset($refunded_items[$item_id]['qty']) || !$item->meta_exists(Orders::REDUCED_STOCK_META)) {
				continue;
			}

			$order_items[] = [$item, (float)$refunded_items[$item_id]['qty']];
		}

		Orders::update_order_items_attribute_stock($order_items, 'restore', $order);
	}
}
