<?php
namespace Mewz\WCAS\Actions\Admin\Attributes;

use Mewz\Framework\Base\Action;
use Mewz\WCAS\Models\AttributeStock;
use Mewz\WCAS\Util\Attributes;
use Mewz\WCAS\Util\Matches;

class AttributeTermList extends Action
{
	public function __hooks()
	{
		$taxonomy = $this->context->taxonomy;

		add_filter("manage_edit-{$taxonomy}_columns", [$this, 'columns']);
		add_filter("manage_edit-{$taxonomy}_sortable_columns", [$this, 'sortable_columns']);
		add_filter("manage_{$taxonomy}_custom_column", [$this, 'column_output'], 10, 3);
	}

	public function __scripts()
	{
		$this->scripts->enqueue_bundle('@admin/attributes');
	}

	public function columns($columns)
	{
		// insert before `Count` column
		$pos = array_search('posts', array_keys($columns));

		if ($pos !== false) {
			$column = ['mewz_wcas_stock' => __('Stock', 'woocommerce-attribute-stock')];
			$columns = array_slice($columns, 0, $pos, true) + $column + array_slice($columns, $pos, null, true);
		} else {
			$columns['mewz_wcas_stock'] = __('Stock', 'woocommerce-attribute-stock');
		}

	    return $columns;
	}

	public function sortable_columns($columns)
	{
		$columns['mewz_wcas_stock'] = 'mewz_wcas_stock';

		return $columns;
	}

	public function column_output($output, $column_name, $term_id)
	{
		if ($column_name !== 'mewz_wcas_stock') {
			return $output;
		}

		$attribute_id = Attributes::get_attribute_id($this->context->taxonomy);

		$stock_ids = Matches::query_stock($attribute_id, $term_id, 'view', 'id');
		$stock_count = count($stock_ids);

		if ($stock_count === 1) {
			$stock = AttributeStock::instance($stock_ids[0]);

			$edit_url = $stock->edit_url(['_wp_http_referer' => urlencode($_SERVER['REQUEST_URI'])]);
			$title = in_array($attribute_id, $stock->meta('attribute_level', false)) ? __('Edit attribute-level stock', 'woocommerce-attribute-stock') : __('Edit stock', 'woocommerce-attribute-stock');
			$quantity = Matches::get_term_display_quantity($stock, $attribute_id, $term_id);

			$output = '<a href="' . esc_url($edit_url) . '" class="mewz-wcas-stock-link" title="' . esc_attr($title) . '">' . $quantity . '</a>';
		}
		elseif ($stock_count > 1) {
			$qty_range = Matches::get_quantity_range($stock_ids, $attribute_id, $term_id);
			$url = admin_url('edit.php?post_type=mewz_attribute_stock&attribute=' . $attribute_id . '&term=' . $term_id);

			$output = '<a href="' . esc_url($url) . '" class="mewz-wcas-stock-link mewz-wcas-stock-range" title="' . esc_attr__('List stock items', 'woocommerce-attribute-stock') . '">' . $qty_range . '</a>';
		}

		return $output;
	}
}
