<?php
namespace Mewz\WCAS\Actions\Common;

use Mewz\Framework\Base\Action;
use Mewz\WCAS\Util;

class ClearCaches extends Action
{
	public function __hooks()
	{
		add_action('clean_post_cache', [$this, 'clear_post'], 10, 2);
		add_action('mewz_attribute_stock_saved', [$this, 'clear_attribute_stock'], 0);
		add_action('mewz_attribute_stock_before_save', [$this, 'clear_attributes'], 100);

		add_action('update_option_mewz_wcas_limit_product_stock', [$this, 'clear_attribute_stock']);
		add_action('update_option_mewz_wcas_allow_backorders', [$this, 'clear_attribute_stock']);
		add_action('update_option_mewz_wcas_unmatched_any_variations', [$this, 'clear_attribute_stock']);
	}

	public function clear_post($post_id, \WP_Post $post)
	{
		if ($post->post_type === 'mewz_attribute_stock') {
			$this->clear_attribute_stock();
		}
		elseif (in_array($post->post_type, ['product', 'product_variation'])) {
			$this->cache->invalidate('product_' . $post_id);

			if ($post->post_parent) {
				$this->cache->invalidate('product_' . $post->post_parent);
			}
		}
	}

	public function clear_attribute_stock()
	{
		$this->cache->invalidate('stock');

		// clear product transients
		wc_delete_product_transients();
	}

	public function clear_attributes($stock)
	{
		// clear attribute transients
		$attribute_ids = Util\Matches::query()->where('s.stock_id', $stock->id())->col('attribute_id');
		$taxonomies = [];

		foreach ($attribute_ids as $attribute_id) {
			if ($taxonomy = Util\Attributes::get_attribute_name($attribute_id, true)) {
				$taxonomies[] = $taxonomy;
			}
		}

		if ($taxonomies) {
			\WC_Cache_Helper::invalidate_attribute_count($taxonomies);
		}
	}
}
