<?php
namespace Mewz\WCAS\Actions\Admin\Plugin;

use Mewz\Framework\Base\Action;

class PluginLinks extends Action
{
	public function __hooks()
	{
		add_filter('plugin_action_links', [$this, 'plugin_action_links'], 10, 4);
		add_filter('plugin_row_meta', [$this, 'plugin_meta_links'], 10, 4);
	}

	public function plugin_action_links($action_links, $plugin_basename, $plugin_data, $context)
	{
		if ($plugin_basename === $this->plugin->basename) {
			$manage_link = '<a href="' . esc_url(admin_url('edit.php?post_type=mewz_attribute_stock')) . '">' . esc_html__('Manage', 'woocommerce') . '</a>';
			$settings_link = '<a href="' . esc_url(admin_url('admin.php?page=wc-settings&tab=products&section=inventory')) . '">' . esc_html__('Settings') . '</a>';

			$action_links = [
				'manage' => $manage_link,
				'settings' => $settings_link,
			] + $action_links;
		}

		return $action_links;
	}

	public function plugin_meta_links($meta_links, $plugin_basename, $plugin_data, $status)
	{
		if ($plugin_basename === $this->plugin->basename) {
			$meta_links[] = '<a href="' . esc_url($this->plugin->docs_url()) . '" target="_blank">' . esc_html__('Documentation') . '</a>';

			if (MEWZ_WCAS_LITE) {
				$meta_links[] = '<a href="' . esc_url($this->plugin->sale_url()) . '" target="_blank">' . esc_html__('Purchase', 'woocommerce') . '</a>';
			} else {
				$meta_links[] = '<a href="' . esc_url($this->plugin->support_url()) . '" target="_blank">' . esc_html__('Support') . '</a>';
			}
		}

		return $meta_links;
	}
}
