<?php
namespace Mewz\Framework\Services;

use Mewz\Framework\Plugin;

class Config
{
	/** @var Plugin */
	protected $plugin;

	/** @var string */
	protected $file;

	/** @var array */
	protected $config;

	public function __construct(Plugin $plugin, $file)
	{
		$this->plugin = $plugin;
		$this->file = $file;
	}

	/**
	 * @param null $key
	 *
	 * @return array|mixed
	 */
	public function get($key = null)
	{
		if ($this->config === null) {
			$this->config = $this->load();
		}

		$config = apply_filters("{$this->plugin->prefix}_config_{$this->file}", $this->config, $key);

		if ($key === null) {
			return $config;
		} elseif (isset($config[$key])) {
			return apply_filters("{$this->plugin->prefix}_config_{$this->file}_{$key}", $config[$key], $key);
		} else {
			return [];
		}
	}

	/**
	 * @return array
	 */
	protected function load()
	{
		$config = $this->plugin->cache->get($this->file, 'config');

		if ($config === null) {
			$config = require $this->plugin->base_dir . '/config/' . $this->file . '.php';
			$this->plugin->cache->set($this->file, $config, 'config');
		}

		return $config ?: [];
	}
}
